#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <fakemeta_util>
#include <fakemeta_stocks>
#include <hamsandwich>
#include <worms>

new maxplayers

// MODELS
/* 	
	player models, "models\player\wormsbeta"
	All player models are stored in one *.mdl file as submodels
	1-T, 2-CT, 3-T, 4-CT, ...
*/
#define NUM_MODELS 2 // number of models for both teams, =>total = 4 submodels
new const g_TeamModels[] = "wormsbeta"
new const MODEL[] = "model"


// WIND
/* 	
	wind is stored in array[2] - power(0..100) and direction(0..360)
	wind is shown on the radar as hostage(CT) or bomb(T)
	more power, more bigger distance to point(power 100 is shown on radar boundary, power 0 - on the player)
*/
enum
{
	WIND_POWER = 0,
	WIND_ANGLE
}
new g_Wind[2]
new g_iMsgBombDrop,g_iMsgHostagePos
new const g_WindSound[] = "wormsmod/wind2.wav"


// CVARS
new cvar_turns
new cvar_cratechance,cvar_crateprop,cvar_cratedamage,cvar_barrelchance,cvar_cratehp
// CVARS - PLAYER PARAMETERS
new cvar_maxspeed,cvar_health,cvar_gravity
new cvar_minsdelay,cvar_maxsdelay

// MOVEMENT
#define SECOND_JUMP 300.0
new g_iJump[32],g_iSecondJump[32],g_iMove[32]

// SOUNDS
enum
{
	SOUND_MOVE = 0,
	SOUND_JUMP,
	SOUND_SECONDJUMP,
	SOUND_TURN,
	SOUND_WIND,
	SOUND_RANDOM
}
new const g_MoveSound[2][] = {
	"wormsmod/moves/marche1.wav",
	"wormsmod/moves/marche2.wav"
}
new g_iCurrentMove[32]
new const g_JumpSound[2][] = {
	"wormsmod/moves/jump1.wav",
	"wormsmod/moves/jump2.wav"
}
// random sounds from player
new const g_RandomSound[] = "wormsmod/player/ambiance/rien"
new const g_iRandomSoundNum = 16

// TURNS SYSTEM
/*
	4 players can turn at the same time
	There is a system, that controls player's connecting and disconnecting
	and new players are placed into some baskets.
	
	It works fine on tests, but I don't exclude that bugs can exist.
*/
#define BASKET_SIZE 4
#define BASKET_NUM 8  //BASKET_NUM*BASKET_SIZE must be >= maxplayers
new g_iBasket[BASKET_NUM][BASKET_SIZE],g_iBasketSize[BASKET_NUM]
new g_iNumBasket

#define TASK_TURN 26000
#define TASK_LOCK 27000
new g_iActivePlayer[BASKET_NUM]
new g_iLocked[32]
new bool:g_iLockedBasket[BASKET_NUM]

new const g_TurnSound[] = "wormsmod/bell1.wav"

// WEAPONS
#define WEAPON_NUM 9
new g_iNumWeapon[WEAPON_TYPES],g_sWeaponName[WEAPON_TYPES][WEAPON_NUM][32]
new g_iWeaponId[WEAPON_TYPES][WEAPON_NUM],g_iWeaponCost[WEAPON_TYPES][WEAPON_NUM]
new g_iWeaponAmmo[WEAPON_TYPES][WEAPON_NUM]
new g_iWeaponTypeNum[WEAPON_NUM*WEAPON_TYPES][2]
new g_iNumWeapons
new g_iPlayerWeapons[32][WEAPON_TYPES][WEAPON_NUM]
new g_fwWeaponSelected

new const WEAPON_TYPE_NAME[WEAPON_TYPES][] = {
	"Movement",
	"Melee",
	"Rifles",
	"Launchers",
	"Grenades",
	"Explosives",
	"Aircraft",
	"Special"
}


// CRATES
/*
	Only Health, Weapon and Barrel are implemented.
	'Special' is for some bonuses(speed, gravity, ...).
	'Unknown' can be some funny features(for example explosion )
*/
#define WORMS_CRATE 72
enum
{
	CRATE_HEALTH = 0,
	CRATE_WEAPON,
	CRATE_SPECIAL,
	CRATE_UNKNOWN,
	CRATE_BARREL
}
new const g_CrateModel[4][] = {
	"models/worms/crate_health.mdl",
	"models/worms/crate_weapon.mdl",
	"models/worms/crate_special.mdl",
	"models/worms/crate_unknown.mdl"
}

// this variables is needed for loading crate spawns from map
#define MAX_CRATES 64
new g_iCrateId[MAX_CRATES],g_iCrateActive[MAX_CRATES]
new g_iCrateNum
new const g_CrateName[] = "worms_crate"
// BARRELS
new const g_BarrelModel[] = "models/worms/barrel.mdl"
new g_iBarrelId[MAX_CRATES],g_iBarrelEnt[MAX_CRATES]
new g_iBarrelNum
new const g_BarrelName[] = "worms_barrel"


// MENUS
#define TASK_CHECKMENU 23000
new g_iActiveMenu[32] = {-1,...}

// DELETING
#define MAP_ENTITIES 11
static const g_MapEntities[MAP_ENTITIES][24] =
{
	"func_buyzone",
	"func_bomb_target",
	"func_escapezone",
	"func_hostage_rescue",
	"func_vip_safetyzone",
	"hostage_entity",
	"info_bomb_target",
	"info_hostage_rescue",
	"info_vip_start",
	"armoury_entity",
	"game_player_equip"
}


// Global values, for weapon plugins

new g_ActiveWeapon[32] = -1
new g_allowfire[32]
new bool: g_WeaponIgnore[32]
new Float:g_inCharge[32]




//TEMP
/* 
	all this code until plugin_init() is temporarily, need only for debugging
	There are:
	- 3d view (for testing models)
	- console command "wind @power @angle" for wind manipulating, also causes the end of turn
	- console command "reset @id"(in weapons plugin) for reloading player(if something going bad)
	- console command "entnum" for checking number of entities(if some entities are not removing)
*/ 
new bool:debug1 = false
new cam[32]
new const g_sCamclass[] = "PlayerCamera"
public debug_toggle(id)
{
	if(debug1) debug1 = false
	debug1 = true
	console_print(id,"Debug is now %d",debug1)
	return PLUGIN_HANDLED
}
public version(id)
{
	client_print(0,print_chat,"Version %s",VERSION)
}
public Camera(id)
{
	if(!cam[id])
		Create_PlayerCamera( id )
	else cam[id] = 0
	return PLUGIN_HANDLED
}
public Create_PlayerCamera( id )
{
	new iEnt
	static const sClassname[] = "classname"
	while( ( iEnt = engfunc( EngFunc_FindEntityByString, iEnt, sClassname, g_sCamclass ) ) != 0 )
	{
		if( pev( iEnt, pev_owner) == id )
		{
			engfunc( EngFunc_SetView, id, iEnt )
			cam[id] = iEnt
			set_pev( iEnt, pev_nextthink, get_gametime())
			return
		}
	}
	static const sInfo_target[] = "info_target"
	iEnt = engfunc( EngFunc_CreateNamedEntity, engfunc( EngFunc_AllocString, sInfo_target ) )
	if( !iEnt )
		return
	static const sCam_model[] = "models/w_usp.mdl"
	set_pev( iEnt, pev_classname, g_sCamclass )
	engfunc( EngFunc_SetModel, iEnt, sCam_model )
	set_pev( iEnt, pev_solid, SOLID_TRIGGER )
	set_pev( iEnt, pev_movetype, MOVETYPE_FLYMISSILE)
	set_pev( iEnt, pev_owner, id )
	set_pev( iEnt, pev_rendermode, kRenderTransTexture )
	set_pev( iEnt, pev_renderamt, 0.0 )
	engfunc( EngFunc_SetView, id, iEnt )
	cam[id] = iEnt
	set_pev( iEnt, pev_nextthink, get_gametime() )
}
public FM_Think_Hook(ent)
{
	static classname[32]
	pev(ent,pev_classname,classname,31)
	if(pev_valid(ent))
	{
		if(equal(classname,g_sCamclass))
		{
			new id = pev(ent,pev_owner)
			if(!is_user_alive(id))
				return FMRES_IGNORED
			if(!cam[id])
			{
				engfunc( EngFunc_SetView, id, id )
				engfunc( EngFunc_RemoveEntity, ent )
				return FMRES_IGNORED
			}
			static Float:fOrigin[3], Float:fAngle[3],Float: Origin[3]
			pev(id,pev_origin,fOrigin )
			for(new i=0;i<3;i++)
				Origin[i] = fOrigin[i]
			pev(id,pev_v_angle,fAngle )
		
			static Float:fVBack[3]
			angle_vector(fAngle,ANGLEVECTOR_FORWARD,fVBack )
		
			fOrigin[2] += 20.0
		
			fOrigin[0] += ( -fVBack[0] * 150.0 )
			fOrigin[1] += ( -fVBack[1] * 150.0 )
			fOrigin[2] += ( -fVBack[2] * 150.0 )
			new trace
			engfunc(EngFunc_TraceLine,Origin,fOrigin,IGNORE_MONSTERS|IGNORE_GLASS|IGNORE_MISSILE,id,trace)
			get_tr2(trace, TR_vecEndPos, fOrigin)
			free_tr2(trace)
			engfunc( EngFunc_SetOrigin,ent,fOrigin)
		
			set_pev(ent,pev_angles,fAngle )
			set_pev(ent,pev_nextthink,get_gametime())
			pev(id,pev_velocity,fOrigin)
			set_pev(ent,pev_velocity,fOrigin)
		}
	}
	return FMRES_HANDLED
}

public EntNum(id) 
{
	client_print(id,print_center,"ents = %d(of %d)",engfunc(EngFunc_NumberOfEntities),global_get(glb_maxEntities))
	return PLUGIN_HANDLED
} 
public Wind(id,level,cid)
{
	if(!cmd_access(id,level,cid,3))
	{
		return PLUGIN_HANDLED
	}
	new arg[5]
	read_argv(1,arg,4)
	new p = str_to_num(arg)
	read_argv(2,arg,4)
	new a = str_to_num(arg)
	g_Wind[WIND_POWER] = p
	g_Wind[WIND_ANGLE] = a
	for(new i=1;i<=maxplayers;i++)
		if(is_user_connected(i))
		{
			play_sound(i,SOUND_TURN)
			play_sound(i,SOUND_WIND,_,75+g_Wind[WIND_POWER])
		}
	turn()
	return PLUGIN_HANDLED
}
public Wind1(id)
{
	client_print(id,print_chat,"%d(%d)",g_Wind[WIND_POWER],g_Wind[WIND_ANGLE])
}


//PLUGIN
public plugin_init() 
{
	register_plugin("WORMS", VERSION, "Monyak")
	// CVARS
	
	cvar_maxspeed = register_cvar("worms_speed","75.0")
	cvar_health = register_cvar("worms_health","200.0")
	cvar_gravity = register_cvar("worms_gravity","600.0")
	
	// To turn on/off "Turn system" (baskets and other)
	cvar_turns = register_cvar("worms_turns","1")
	
	// Delay between random sounds
	cvar_minsdelay = register_cvar("worms_minsounddelay","30")
	cvar_maxsdelay = register_cvar("worms_maxsounddelay","150")
	
	// chance for crate spawning on every turn
	cvar_cratechance = register_cvar("worms_cratechance","5") // max - 100%
	// choose what crates will spawn, for "Health & Weapon only" use "1100"
	cvar_crateprop = register_cvar("worms_crateprop","1111") // hp weapon special random
	// chance for barrel spawning on round start(not every turn!)
	cvar_barrelchance = register_cvar("worms_barrelchance","50")
	
	// crate damage and hp, used for crate explosion
	cvar_cratedamage = register_cvar("worms_cratedamage","50.0") 
	cvar_cratehp = register_cvar("worms_cratehp","50.0")
	
	// EVENTS
	register_event("HLTV", "event_newround", "a", "1=0", "2=0")
	
	
	// FORWARDS
	register_forward(FM_PlayerPreThink,"FM_playerPreThink_hook")
	register_forward(FM_Touch, "FM_touch_hook")	
	register_forward(FM_SetClientKeyValue, "FM_setClientKeyValue_hook")
	RegisterHam(Ham_Spawn,"player","Ham_spawn_hook",1)
	
	register_message( get_user_msgid( "ClCorpse" ), "EventClCorpse" )
	
	
	// MENUS
	register_menu("WeaponType",1023,"menu_weapontype")
	register_menu("SelectWeapon",1023,"menu_selectweapon")
	//register_menu("SelectDelay",1023,"menu_selectdelay")
	
	// send control to weapon's plugin
	g_fwWeaponSelected = CreateMultiForward("worms_weapon_selected",ET_CONTINUE,FP_CELL,FP_CELL)
	
	maxplayers = get_maxplayers()
	
	set_task(30.0,"turn",TASK_TURN)
	set_task(1.0,"update_radar",_,_,_,"b")
	
	remove_entities()
	load_crates()
	load_barrels()
	// COMMANDS
	
	// MESSAGES
	g_iMsgBombDrop   = get_user_msgid("BombDrop")
	g_iMsgHostagePos = get_user_msgid("HostagePos")
	
	//TEMP
	// for debugging
	server_cmd("amx_restrict on")
	register_concmd("debug","debug_toggle",ADMIN_BAN)
	register_clcmd("say /3d","Camera")
	register_clcmd("entnum","EntNum")
	register_clcmd("say /w","Wind1")
	register_clcmd("say version","version")
	register_concmd("wind","Wind",ADMIN_BAN)
	register_forward(FM_Think, "FM_Think_Hook")	
	
}
public plugin_precache()
{
	new i
	new model_string[50]
	format(model_string,49,"models/player/%s/%s.mdl",g_TeamModels,g_TeamModels)
	precache_model(model_string)
	
	for(i=0;i<g_iRandomSoundNum;i++)
	{
		format(model_string,49,"%s%s%d.wav",g_RandomSound,(i+1)<10?"0":"",i+1)
		precache_sound(model_string)
	}
	
	precache_sound(g_WindSound)
	precache_sound(g_TurnSound)
	for(i=0;i<2;i++)
	{
		precache_sound(g_MoveSound[i])
		precache_sound(g_JumpSound[i])
	}
	for(i=0;i<4;i++)
		precache_model(g_CrateModel[i])
	precache_model(g_BarrelModel)
}
public plugin_natives()
{
	register_native("worms_register_weapon","native_register_weapon",1)
	register_native("worms_get_user_ammo","native_get_user_ammo",1)
	register_native("worms_set_user_ammo","native_set_user_ammo",1)
	register_native("worms_use_user_ammo","native_use_user_ammo",1)
	register_native("worms_allow_fire","native_allow_fire",1)
	register_native("worms_get_wind_power","native_get_wind_power",1)
	register_native("worms_get_wind_direction","native_get_wind_direction",1)
	register_native("worms_is_user_locked","native_is_user_locked",1)
	register_native("worms_get_weapon_type","native_get_weapon_type",1)
	register_native("worms_lock_player","native_lock_player",1)
	
	register_native("worms_set_active_weapon","native_set_active_weapon",1)
	register_native("worms_set_allowfire","native_set_allowfire",1)
	register_native("worms_set_weapon_ignore","native_set_weapon_ignore",1)
	register_native("worms_set_incharge","native_set_incharge",1)
	
	register_native("worms_get_active_weapon","native_get_active_weapon",1)
	register_native("worms_get_allowfire","native_get_allowfire",1)
	register_native("worms_get_weapon_ignore","native_get_weapon_ignore",1)
	register_native("worms_get_incharge","native_get_incharge",1)
	
	
}

public client_putinserver(id)
{
	set_task(2.0,"check_menu",id+TASK_CHECKMENU,_,_,"b")
	put_into_basket(id)
	set_task(float(random_num(30,120)),"random_sound",id)
}
public client_disconnect(id)
{
	remove_task(id+TASK_CHECKMENU)
	remove_from_basket(id)
}




public Ham_spawn_hook(id)
{
	if(!is_user_alive(id))
		return HAM_IGNORED
	fm_strip_user_weapons(id)
	//cs_set_user_model(id, g_TeamModels)
	set_user_info(id,MODEL,g_TeamModels)
	set_pev(id,pev_body,get_user_team(id)+random(NUM_MODELS)*2)
	set_task(0.5,"post_spawn",id)
	return HAM_IGNORED
}
public post_spawn(id)
{
	if(is_user_alive(id))
	{
		reset_menu(id)
		set_pev(id,pev_maxspeed,get_pcvar_float(cvar_maxspeed))
		set_pev(id,pev_max_health,get_pcvar_float(cvar_health))
		set_pev(id,pev_health,get_pcvar_float(cvar_health))
		set_pev(id,pev_gravity,get_pcvar_float(cvar_gravity)/800)
		new type,weapon
		for(new i=0;i<g_iNumWeapons;i++)
		{
			type = g_iWeaponTypeNum[i][0]
			weapon = g_iWeaponTypeNum[i][1]
			if(g_iPlayerWeapons[id][type][weapon] < g_iWeaponAmmo[type][weapon])
				g_iPlayerWeapons[id][type][weapon] = g_iWeaponAmmo[type][weapon]
		}
	}
}
public FM_playerPreThink_hook(id)
{
	if(!is_user_alive(id))
		return FMRES_IGNORED
	set_pev(id,pev_flTimeStepSound,999)
	new buttons = pev(id,pev_button)
	//if(buttons & IN_JUMP && g_iLocked[id])
	//	set_pev(id,pev_button,buttons - IN_JUMP)
	if(!in_air(id))
	{
		if(in_jumping(id) && !g_iJump[id])
			play_sound(id,SOUND_JUMP)
		else if(in_move(id) && !g_iMove[id] && !g_iLocked[id])
			play_sound(id,SOUND_MOVE)
	}
	else if(in_jumping(id) && g_iJump[id] == 1 && !g_iLocked[id])
		second_jump(id)
	if(buttons & IN_ATTACK && g_iActiveMenu[id] >= 0 && !g_iLocked[id])
	{
		show_active_menu(id)
	}
	if(buttons & IN_ATTACK2 && g_iActiveMenu[id] >= 0)
	{
		reset_menu(id)
		set_task(0.2,"hide_menu",id)
	}
	
	return FMRES_IGNORED
}
public hide_menu(id)
{
	g_iActiveMenu[id] = -1
	reset_menu(id)
}
public FM_touch_hook( ent1, ent2)
{
	if(!ent2)
		return FMRES_IGNORED
	new classname[20]
	pev(ent1,pev_classname,classname,19)
	if(equal(classname,g_CrateName))
	{
		if(!is_user_connected(ent2) && pev_valid(ent2))
		{
			new classname[32]
			static const sheepClass[] = "SuperSheep"
			pev(ent2,pev_classname,classname,31)
			if(equal(classname,sheepClass))
				ent2 = pev(ent2,pev_weaponowner)		
		}
		if(is_user_connected(ent2))
			give_crate_item(ent2,ent1)
	}
	return FMRES_IGNORED
}

public EventClCorpse(msgid, dest, id )
{
	return PLUGIN_HANDLED
}

// EVENTS
public event_newround()
{	
	remove_task(TASK_TURN)
	set_task(0.5,"allocate_players")
	set_task(1.0,"turn",TASK_TURN)
	
	static const classname[] = "classname"
	new ent = 0
	while((ent = engfunc(EngFunc_FindEntityByString,ent,classname,"Mine")) > 0)
		if(pev_valid(ent))
			fm_remove_entity(ent)
	while((ent = engfunc(EngFunc_FindEntityByString,ent,classname,g_CrateName)) > 0)
		if(pev_valid(ent))
			fm_remove_entity(ent)
	while((ent = engfunc(EngFunc_FindEntityByString,ent,classname,g_BarrelName)) > 0)
		if(pev_valid(ent))
			fm_remove_entity(ent)
	while((ent = engfunc(EngFunc_FindEntityByString,ent,classname,"Rip")) > 0)
		if(pev_valid(ent))
			fm_remove_entity(ent)
	reset_barrels()
}

// WEAPONS
public native_register_weapon(const name[],type,default_count,cost)
{
	if(type < 0 || type >= WEAPON_TYPES)
		return -1
	if(g_iNumWeapon[type] >= WEAPON_NUM)
		return -1
	param_convert(1)
	copy(g_sWeaponName[type][g_iNumWeapon[type]],31,name)
	g_iWeaponCost[type][g_iNumWeapon[type]] = cost > 0? cost : 0
	g_iWeaponAmmo[type][g_iNumWeapon[type]] = default_count > 0? default_count : 0
	g_iWeaponId[type][g_iNumWeapon[type]] = g_iNumWeapons
	g_iWeaponTypeNum[g_iNumWeapons][0] = type
	g_iWeaponTypeNum[g_iNumWeapons][1] = g_iNumWeapon[type]
	g_iNumWeapon[type]++
	g_iNumWeapons++
	return g_iNumWeapons
}
public native_get_user_ammo(id,weaponid)
{
	weaponid--
	if(weaponid < 0 || weaponid >= g_iNumWeapons)
		return -1
	new type = g_iWeaponTypeNum[weaponid][0]
	new weapon = g_iWeaponTypeNum[weaponid][1]
	if(type < 0 || type >= WEAPON_TYPES)
		return -1
	if(weapon >= WEAPON_NUM)
		return -1
	return g_iPlayerWeapons[id][type][weapon]
}
public native_use_user_ammo(id,weaponid)
{
	weaponid--
	if(weaponid < 0 || weaponid >= g_iNumWeapons)
		return -1
	new type = g_iWeaponTypeNum[weaponid][0]
	new weapon = g_iWeaponTypeNum[weaponid][1]
	if(type < 0 || type >= WEAPON_TYPES)
		return -1
	if(weapon >= WEAPON_NUM)
		return -1
	return --g_iPlayerWeapons[id][type][weapon]
}
public native_set_user_ammo(id,weaponid,value)
{
	weaponid--
	if(weaponid < 0 || weaponid >= g_iNumWeapons)
		return -1
	new type = g_iWeaponTypeNum[weaponid][0]
	new weapon = g_iWeaponTypeNum[weaponid][1]
	if(type < 0 || type >= WEAPON_TYPES)
		return -1
	if(weapon >= WEAPON_NUM)
		return -1
	if(value > 0)
	g_iPlayerWeapons[id][type][weapon] = value
	return 0
}
public native_allow_fire(id)
{
	if(id <= 0 || id > maxplayers)
		return false
	if(g_iActiveMenu[id] >= 0)
		return false
	if(g_iLocked[id])
		return false
	return true
}
public native_get_wind_power()
{
	return g_Wind[WIND_POWER]
}
public native_get_wind_direction()
{
	return g_Wind[WIND_ANGLE]
}
public native_is_user_locked(id)
{
	return g_iLocked[id]
}
public native_get_weapon_type(weaponid)
{
	return g_iWeaponTypeNum[weaponid-1][0]
}
public native_lock_player(id,Float:delay)
{
	if(delay == 0.0) lock_player2(id+TASK_TURN)
	else set_task(delay,"lock_player2",id+TASK_LOCK)
}
public native_set_active_weapon(id, weaponid)
{
	g_ActiveWeapon[id] = weaponid
}
public native_get_active_weapon(id)
{
	return g_ActiveWeapon[id]
}
public native_set_allowfire(id, value)
{
	g_allowfire[id] = value
}
public native_get_allowfire(id)
{
	return g_allowfire[id]
}
public native_set_weapon_ignore(id, bool:value)
{
	g_WeaponIgnore[id] = value
}
public bool:native_get_weapon_ignore(id)
{
	return g_WeaponIgnore[id]
}
public native_set_incharge(id, Float:value)
{
	g_inCharge[id] = value
}
public Float:native_get_incharge(id)
{
	return g_inCharge[id]
}

// MENU SYSTEM
stock reset_menu(id, menu[] = "^n")
{
	if(is_user_connected(id))
		show_menu(id,(1<<WEAPON_TYPES) - 1,menu,-1,"WeaponType")
}
public menu_weapontype(id,key)
{
	if(g_iActiveMenu[id] == key || pev(id,pev_button) & IN_ATTACK)
	{
		reset_menu(id)
		g_iActiveMenu[id] = -1
		return
	}
	new text[200]
	new len = 0,ammo
	len += formatex(text[len],200-len,"\d%s:^n(Click to select)^n^n",WEAPON_TYPE_NAME[key])
	for(new i=0;i<g_iNumWeapon[key];i++)
	{
		ammo = g_iPlayerWeapons[id][key][i]
		if(ammo > 0)
			len += formatex(text[len],200-len,"%d. %s (%d)^n",
				i+1,g_sWeaponName[key][i],ammo)
	}
	g_iActiveMenu[id] = key
	reset_menu(id,text)
}
public show_active_menu(id)
{
	new text[200]
	new len = 0,ammo,num = 0
	new key = g_iActiveMenu[id] 
	len += formatex(text[len],200-len,"\r%s:^n^n",WEAPON_TYPE_NAME[key])
	for(new i=0;i<g_iNumWeapon[key];i++)
	{
		ammo = g_iPlayerWeapons[id][key][i]
		if(ammo > 0)
		{
			num += 1<<i
			len += formatex(text[len],200-len,"\r%d. \y%s \w(%d)^n",
				i+1,g_sWeaponName[key][i],ammo)
		}
	}
	len += formatex(text[len],200-len,"^n^n\r0. \yBack^n")
	show_menu(id,num | MENU_KEY_0,text,-1,"SelectWeapon")
}
public menu_selectweapon(id,key)
{
	if(key == 9 || !is_user_alive(id) || g_iLocked[id])
	{
		g_iActiveMenu[id] = -1
		reset_menu(id)
		return
	}
	new tmp
	ExecuteForward(g_fwWeaponSelected,tmp,id,g_iWeaponId[g_iActiveMenu[id]][key]+1)
	g_iActiveMenu[id] = -1
	return
}
/*public ShowDelayMenu(id)
{
	new text[200]
	new len = 0
	len += formatex(text[len],200-len,"\rChoose delay:^n^n")
	for(new i=1;i<=5;i++)
	{
		len += formatex(text[len],200-len,"%s%d^n",
			g_iWeaponDelay[id] == i?"/w":"/y",i)
	}
	new keys = (1<<5) - 1
	show_menu(id,keys,text,10,"SelectDelay")
}
public menu_selectdelay(id,key)
{
	g_iWeaponDelay[id] = key + 1
}*/
public check_menu(id)
{
	id -= TASK_CHECKMENU
	if(!is_user_connected(id))
		return
	new menu_id, tmp 
	new menuUp = player_menu_info( id, menu_id, tmp )
	if (menuUp <= 0 || menu_id < 0) 
	{
		g_iActiveMenu[id] = -1
		reset_menu(id)
	}
}
// TURNS SYSTEM
public allocate_players()
{
	new numplayers,iPlayers[32]
	get_players(iPlayers,numplayers,"h")
	reset_buskets()
	if(!numplayers)
		return
	distribute_baskets(numplayers)
	fill_baskets(iPlayers,numplayers)
		
}
public reset_buskets()
{
	for(new i=0;i<BASKET_NUM;i++)
	{
		g_iActivePlayer[i] = -1
		g_iBasketSize[i] = 0
		for(new j=0;j<BASKET_SIZE;j++)
			g_iBasket[i][j] = 0
	}
}
public distribute_baskets(numplayers)
{
	new i
	g_iNumBasket = floatround(1.0*numplayers/BASKET_SIZE,floatround_ceil)
	new imax = floatround(1.0*numplayers/g_iNumBasket,floatround_ceil)
	for(i=0;i<g_iNumBasket;i++)
		g_iBasketSize[i] = imax
	if(numplayers%BASKET_SIZE && imax > numplayers/g_iNumBasket)
		for(i=0;i<BASKET_SIZE-numplayers%BASKET_SIZE && i<g_iNumBasket-1;i++)
			g_iBasketSize[g_iNumBasket - i - 1] = imax - 1
}
public fill_baskets(iPlayers[],numplayers)
{
	randomize(iPlayers,numplayers)
	new basket = 0,num = 0
	for(new i=0;i<numplayers;i++)
	{
		g_iBasket[basket][num++] = iPlayers[i]
		if(num == g_iBasketSize[basket])
		{
			basket++
			num = 0
		}
	}
}
public randomize(array[],size)
{
	new temp,k
	for(new i=0;i<size;i++)
	{
		k = random(size-i) + i
		temp = array[i]
		array[i] = array[k]
		array[k] = temp
	}
}
public put_into_basket(id)
{
	new i
	if(debug1)log_amx("Old")
	if(debug1)write_baskets()
	for(i=g_iNumBasket-1;i>=0;i--)
		if(g_iBasketSize[i]<BASKET_SIZE)
		{
			if(i > 0)
				if(g_iBasketSize[i-1] < g_iBasketSize[i])
					put_into_basket_end(id,i-1)
				else put_into_basket_end(id,i)
			else put_into_basket_end(id,i)
			if(debug1)log_amx("New")
			if(debug1)write_baskets()
			return
		}
	put_into_basket_end(id,g_iNumBasket++)
	if(debug1)log_amx("New")
	if(debug1)write_baskets()
}
public put_into_basket_end(id,basket)
{
	new i
	for(i=0;i<BASKET_SIZE;i++)
		if(!g_iBasket[basket][i])
		{
			g_iBasket[basket][i] = id
			g_iBasketSize[basket]++
			return
		}
}
public remove_from_basket(id)
{
	new i,j
	new k = -1,l
	for(i=0;i<g_iNumBasket;i++)
	{
		for(j=0;j<g_iBasketSize[i];j++)
			if(g_iBasket[i][j] == id)
			{
				k = i
				l = j
				g_iBasket[i][j] = 0
				break
			}
		if(k >= 0) break
	}
	if(k == -1)
		return
	if(l == g_iBasketSize[k] - 1)
	{
		//log_amx("1")
		if(g_iBasketSize[k] > 1)
		{
			g_iBasket[k][g_iBasketSize[k] - 1] = 0
			g_iBasketSize[k]--
			return
		}
		else
		{
			//log_amx("2")
		
			g_iBasketSize[k]--
			if(k == g_iNumBasket - 1)
			{
				g_iNumBasket--
				return
			}
		}
	}
	else 
	{
		for(j=l;j<g_iBasketSize[k] - 1;j++)
			g_iBasket[k][j] = g_iBasket[k][j+1]
		g_iBasket[k][g_iBasketSize[k] - 1] = 0
		g_iBasketSize[k]--
	}
}
public check_baskets()
{
	new i,j,n = 0
	for(i=0;i<g_iNumBasket;i++)
		for(j=0;j<g_iBasketSize[i];j++)
		{
			if(!is_user_alive(g_iBasket[i][j]))
				remove_from_basket(g_iBasket[i][j--])
			if(n++ == 16)
			{
				log_amx("Looping")
				break
			}
		}
}
public empty_basket(k)
{
	if(k < 0 || k >= g_iNumBasket)
		return true
	return (g_iBasketSize[k] == 0)
}
public turn()
{
	new i
	if(task_exists(TASK_TURN))
		remove_task(TASK_TURN)
	for(i=0;i<BASKET_NUM;i++)
		g_iLockedBasket[i] = false
	random_wind()
	random_crates()
	for(i=1;i<=maxplayers;i++)
		if(is_user_connected(i))
		{
			if(task_exists(i+TASK_LOCK))
				remove_task(i+TASK_LOCK)
			play_sound(i,SOUND_TURN)
			play_sound(i,SOUND_WIND,_,75+g_Wind[WIND_POWER])
		}
			
	check_baskets()
	for(i=0;i<g_iNumBasket;i++)
		if(!empty_basket(i))
		{
			if(++g_iActivePlayer[i] >= g_iBasketSize[i])
				g_iActivePlayer[i] = 0
		}
	if(debug1)log_amx("Round start!")
	if(debug1)write_baskets()
	unlock_players()
	set_task(30.0,"turn",TASK_TURN)
}
// temp
public write_baskets()
{
	new temp[64]
	for(new i=0;i<BASKET_NUM;i++)
	{
		format(temp,63,"%s^n",temp)
		for(new j=0;j<BASKET_SIZE;j++)
			format(temp,63,"%s%d(%d) ",temp,g_iBasket[i][j],is_user_alive(g_iBasket[i][j]))
	}
	log_amx(temp)
}
// /temp
public unlock_players()
{
	new ids[32],n,i
	get_players(ids,n,"h")
	new Float: speed = get_pcvar_float(cvar_maxspeed)
	for(i=0;i<n;i++)
	{
		if(get_pcvar_num(cvar_turns))
			lock_player(ids[i])
		else 
		{
			set_pev(ids[i],pev_maxspeed,speed)	
			g_iLocked[ids[i]] = 0
		}
	}
	if(!get_pcvar_num(cvar_turns))
		return
	for(i=0;i<g_iNumBasket;i++)
	{
		if(debug1)log_amx("index = %d",g_iActivePlayer[i])
		if(debug1)log_amx("Basket(%d,%d) = %d",i,g_iActivePlayer[i],g_iBasket[i][g_iActivePlayer[i]])
		if(g_iActivePlayer[i] == -1)
			continue
		set_pev(g_iBasket[i][g_iActivePlayer[i]],pev_maxspeed,speed)
		g_iLocked[g_iBasket[i][g_iActivePlayer[i]]] = 0
	}
}
public lock_player(id)
{
	if(!get_pcvar_num(cvar_turns))
		return
	if(!(0<=id<=maxplayers))
		return
	if(pev_valid(id))
		set_pev(id,pev_maxspeed,1.0)
	g_iLocked[id] = 1
}
public lock_player2(id)
{
	id -= TASK_LOCK
	lock_player(id)
	for(new i=0;i<g_iNumBasket;i++)
		if(0<=g_iActivePlayer[i]<BASKET_SIZE)
		if(id == g_iBasket[i][g_iActivePlayer[i]])
		{
			g_iLockedBasket[i] = true
			check_turn()
			break
		}
}
public check_turn()
{
	if(!get_pcvar_num(cvar_turns))
		return
	new bool:flag = true
	for(new i=0;i<g_iNumBasket;i++)
		if(!g_iLockedBasket[i])
		{
			flag = false
			break
		}
	if(flag) set_task(1.0,"turn",TASK_TURN)
}
public random_wind()
{
	g_Wind[WIND_POWER] = random(MAX_WIND)
	g_Wind[WIND_ANGLE] = random(360)
}
public update_radar()
{
	new ids[32],n
	new Float:origin[3]
	
	get_players(ids,n,"a")
	for(new i=0;i<n;i++)
	{
		pev(ids[i],pev_origin,origin)
		new Float:radius = 2000.0*g_Wind[WIND_POWER]/MAX_WIND
		origin[0] += radius*floatcos(1.0*g_Wind[WIND_ANGLE],degrees)
		origin[1] += radius*floatsin(1.0*g_Wind[WIND_ANGLE],degrees)
		//origin[2] += 4096.0*
		new team = get_user_team(ids[i])
		if(team == FM_CS_TEAM_T)
		{
			message_begin(MSG_ONE_UNRELIABLE, g_iMsgBombDrop,{0,0,0},ids[i])
			write_coord(floatround(origin[0]))	//X Coordinate
			write_coord(floatround(origin[1]))	//Y Coordinate
			write_coord(floatround(origin[2]))	//Z Coordinate
			write_byte(0)			//?? This byte seems to always be 0...so, w/e
			message_end()
		}
		if(team == FM_CS_TEAM_CT)
		{
			message_begin(MSG_ONE_UNRELIABLE, g_iMsgHostagePos,{0,0,0},ids[i])
			write_byte(1)			//No idea what this byte does; I think it has something to do with whether or not the hostage is following someone
			write_byte(1)			//The number of the hostage, 1-4
			write_coord(floatround(origin[0]))	//X Coordinate
			write_coord(floatround(origin[1]))	//Y Coordinate
			write_coord(floatround(origin[2]))	//Z Coordinate
			message_end()
		}
	}
}
// CRATES
public load_crates()
{
	new ent = 0
	static const targetname[] = "targetname"
	while((ent = engfunc(EngFunc_FindEntityByString,ent,targetname, g_CrateName)) > 0)
	if(g_iCrateNum < MAX_CRATES)
		g_iCrateId[g_iCrateNum++] = ent
	else break
}
public random_crates()
{
	new chance = get_pcvar_num(cvar_cratechance)
	for(new i=0;i<g_iCrateNum;i++)
		if(random(100) < chance && !pev_valid(g_iCrateActive[i]))
			g_iCrateActive[i] = create_crate(g_iCrateId[i],get_crate_type())
		else if(pev_valid(g_iCrateActive[i]))
			if(pev(g_iCrateActive[i],pev_iuser1) != WORMS_CRATE)
				g_iCrateActive[i] = create_crate(g_iCrateId[i],get_crate_type())
}
public create_crate(ent,type)
{
	new crate = fm_create_entity("info_target")
	if(!pev_valid(crate)) return 0
	if(type != 4)engfunc(EngFunc_SetModel,crate,g_CrateModel[type])
	else engfunc(EngFunc_SetModel,crate,g_BarrelModel)
	new Float:origin[3]
	pev(ent,pev_origin,origin)
	origin[2] += 16
	set_pev(crate,pev_origin,origin)
	//set_pev(crate,pev_solid,(type == CRATE_BARREL)?SOLID_SLIDEBOX:SOLID_TRIGGER)
	set_pev(crate,pev_solid,SOLID_SLIDEBOX)
	set_pev(crate,pev_movetype,MOVETYPE_BOUNCE)
	new Float:mins[3],Float:maxs[3]
	pev(crate,pev_absmin,mins)
	pev(crate,pev_absmax,maxs)
	for(new i=0;i<2;i++)
	{
		mins[i] -= 16
		maxs[i] += 16
	}
	maxs[2] += 32

	fm_entity_set_size(crate,mins,maxs)
	set_pev(crate,pev_classname,(type == CRATE_BARREL)?g_BarrelName:g_CrateName)
	set_pev(crate,pev_weaponclass,WORMS_CRATE)
	set_pev(crate,pev_iuser3,type)
	set_pev(crate,pev_worms,WORMS_WEAPON) 
	set_pev(crate,pev_shift,0.02)
	//set_pev(crate,pev_shift,0.05)
	set_pev(crate,pev_health,get_pcvar_float(cvar_cratehp))
	set_pev(crate,pev_damage,get_pcvar_float(cvar_cratedamage))
	set_pev(crate,pev_sequence,0)
	set_pev(crate,pev_framerate,1.0)
	set_pev(crate,pev_frame,random(30))
	set_pev(crate,pev_nextthink,get_gametime()+0.1)
	origin[0] = 0.0
	origin[1] = 0.0
	origin[2] = -150.0
	set_pev(crate,pev_velocity,origin)
	return crate
}
public get_crate_type()
{
	new proportion = get_pcvar_num(cvar_crateprop)
	new types[4]
	types[0] = proportion/1000
	types[1] = proportion/100 - types[0] * 10
	types[2] = proportion/10 - types[1]*10 - types[0]*100
	types[3] = proportion - types[2]*10 - types[1]*100 - types[0]*1000
	new i,j
	for(i=3;i>=1;i--)
		for(j=0;j<i;j++)
			types[i] += types[j]
	new r = random(types[3])
	for(i=0;i<4;i++)
		if(r < types[i])
			return i
	return 0
}
public give_crate_item(id,ent)
{
	new type = pev(ent,pev_iuser3)
	fm_remove_entity(ent)
	if(!is_user_connected(id))
		return
	if(type == CRATE_UNKNOWN)
		type = random(4)
	give_item(id,type)
}
public give_item(id,type)
{
	if(type == CRATE_HEALTH) give_health(id)
	else if(type ==CRATE_WEAPON) give_weapon(id)
	else client_print(id,print_center,"Nothing happened, probably it doesn't work yet ;)")
}
public give_health(id)
{
	fm_fakedamage(id,"worldspawn",-get_pcvar_float(cvar_cratehp),DMG_SONIC)
}
public give_weapon(id)
{
	new sum=0
	new i,type,num
	new costs[WEAPON_TYPES*WEAPON_NUM]
	for(i=0;i<g_iNumWeapons;i++)
	{
		type = g_iWeaponTypeNum[i][0]
		num = g_iWeaponTypeNum[i][1]
		sum += g_iWeaponCost[type][num]
		costs[i] = sum
	}
	new r = random(sum)
	for(i=0;i<g_iNumWeapons;i++)
		if(r<costs[i])
		{
			type = g_iWeaponTypeNum[i][0]
			num = g_iWeaponTypeNum[i][1]
			g_iPlayerWeapons[id][type][num]++
			client_print(id,print_center,"You got %s",g_sWeaponName[type][num])
			break
		}
}
// BARRELS
public load_barrels()
{
	new ent = 0
	static const targetname[] = "targetname"
	while((ent = engfunc(EngFunc_FindEntityByString,ent,targetname, g_BarrelName)) > 0)
	if(g_iBarrelNum < MAX_CRATES)
		g_iBarrelId[g_iBarrelNum++] = ent
	else break
}
public reset_barrels()
{
	new chance = get_pcvar_num(cvar_barrelchance)
	for(new i=0;i<g_iBarrelNum;i++)
		if(random(100) < chance && !pev_valid(g_iBarrelEnt[i]))
			g_iBarrelEnt[i] = create_crate(g_iBarrelId[i],CRATE_BARREL)
		else if(pev_valid(g_iBarrelEnt[i]))
			if(pev(g_iBarrelEnt[i],pev_iuser1) != WORMS_CRATE)
				g_iBarrelEnt[i] = create_crate(g_iBarrelId[i],CRATE_BARREL)
}
// SOUNDS
stock play_sound(ent, type, Float:origin[3] = {0.0,0.0,0.0},pitch = PITCH_NORM)
{
	if(ent)
	{
		if(!pev_valid(ent))
			return
		pev(ent,pev_origin,origin)
		if(ent <= maxplayers)
		{
			if(type == SOUND_JUMP)
			{
				g_iJump[ent] = 1
				set_task(0.4,"allow_sec_jump",ent)
				set_task(0.7,"reset_jump",ent)
				EF_EmitAmbientSound(ent,origin,g_JumpSound[0], 0.5, ATTN_NORM, 0, pitch)
				return
			}
			if(type == SOUND_SECONDJUMP)
			{
				g_iJump[ent] = 2
				set_task(0.5,"reset_jump",ent)
				EF_EmitAmbientSound(ent,origin,g_JumpSound[1], 0.5, ATTN_NORM, 0, pitch)
				return
			}
			if(type == SOUND_MOVE)
			{
				g_iMove[ent] = 1
				set_task(0.7,"reset_move",ent)
				EF_EmitAmbientSound(ent,origin,g_MoveSound[g_iCurrentMove[ent]], 0.5, ATTN_NORM, 0, pitch)
				g_iCurrentMove[ent] = g_iCurrentMove[ent]?0:1
				return
			}
			if(type == SOUND_TURN)
			{
				EF_EmitAmbientSound(ent,origin,g_TurnSound, 0.5, ATTN_NORM, 0, pitch)
				return
			}
			if(type == SOUND_WIND)
			{
				EF_EmitAmbientSound(ent,origin,g_WindSound, 0.2, ATTN_NORM, SND_CHANGE_PITCH, pitch)
				
				//EF_EmitAmbientSound(ent,origin,g_WindSound, 0.2, ATTN_NORM, 0, pitch)
				return
			}
			if(type == SOUND_RANDOM)
			{
				new sound[50]
				new rand = random(g_iRandomSoundNum)
				format(sound,49,"%s%s%d.wav",g_RandomSound,(rand+1)<10?"0":"",rand+1)
				EF_EmitAmbientSound(ent,origin,sound, 1.0, ATTN_NORM, 0, pitch)
				return
			}
		}
	}
}
public random_sound(id)
{
	if(is_user_alive(id))
		play_sound(id,SOUND_RANDOM)
	new mins = get_pcvar_num(cvar_minsdelay)
	new maxs = get_pcvar_num(cvar_maxsdelay)
	if(is_user_connected(id))
		set_task(float(random_num(mins,maxs)),"random_sound",id)
}
//MOVEMENTS
stock in_move(id)
{
	new moves = IN_FORWARD | IN_BACK | IN_MOVELEFT | IN_MOVERIGHT
	return pev(id,pev_button) & moves
}
stock in_jumping(id)
{
	return (pev(id,pev_button) & IN_JUMP ) && !(pev(id,pev_oldbuttons) & IN_JUMP)
}
stock in_air(id)
{
	return !(pev(id,pev_flags) & FL_ONGROUND)
}
stock second_jump(id)
{
	new Float:velocity[3]
	pev(id,pev_velocity,velocity)
	velocity[2] = SECOND_JUMP
	set_pev(id,pev_velocity,velocity)
	play_sound(id,SOUND_SECONDJUMP)
}
public allow_sec_jump(id)
{
	g_iSecondJump[id] = 1
}
public reset_jump(id)
{
	g_iJump[id] = 0
	g_iSecondJump[id] = 0
}
public reset_move(id)
{
	g_iMove[id] = 0
}

// ENTITY

public remove_entities()
{
	new ent,i
	static const classname[] = "classname"
	for(i=0;i<MAP_ENTITIES;i++)
	{
		ent = 0
		while((ent = engfunc(EngFunc_FindEntityByString,ent,classname,g_MapEntities[i])) > 0)
		if(pev_valid(ent))
			fm_remove_entity(ent)
	}
	ent = 0
	new Float:mins[3],Float:maxs[3]
	static const water[] = "func_water"
	while((ent = engfunc(EngFunc_FindEntityByString,ent,classname,water)) > 0)
	if(pev_valid(ent))
	{
		pev(ent,pev_absmin,mins)
		pev(ent,pev_absmax,maxs)
		create_hurt(mins,maxs,100.0)
	}
}

stock create_hurt(Float: mins[3],Float:maxs[3],Float:dmg)
{
	new ent = fm_create_entity("trigger_hurt")
	fm_DispatchSpawn(ent)
	set_pev(ent,pev_absmax,maxs)
	set_pev(ent,pev_absmin,mins)
	set_pev(ent,pev_dmg,dmg)
	fm_set_kvd(ent,"damagetype", "16384") // drown
	set_pev(ent,pev_solid,SOLID_TRIGGER)
	return ent
}

// MODELS
public FM_setClientKeyValue_hook(id, szInfoBuffer[], szKey[], szValue[])
{
	if(equal(szKey, MODEL))
	{
		set_user_info(id, MODEL, g_TeamModels)
		return FMRES_SUPERCEDE
	}
	return FMRES_IGNORED
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/
