#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <fakemeta_util>
#include <hamsandwich>
#include <worms>


new maxplayers


new cvars[64] // damage cvars for weapons

#define TASK_RESETFIRE 9000
#define TASK_ANIM 11000

// duration for rockets, grenades...
#define CHARGE_DURATION 2

// zero for float comparisons
#define ZERO 0.001

// FIRE (from barrels)
#define FIRE -17
#define FIRE_FRAGMENTS 8
new const g_FireModel[] = "models/worms/flames.spr"
new g_iFireIndex
new cvar_firedamage

// enum for model type. All weapons must have all this types of models
enum
{
	MODEL_FIRSTPERSON = 0,
	MODEL_THIRDPERSON,
	MODEL_BULLET
}

// sprite index
new g_iBeamIndex

new const g_HandsModel[] = "models/worms/weapons/v_hands.mdl"
new const g_FragModel[] = "models/worms/weapons/r_cluster.mdl"

new const g_ExpSprite[3][] = {
	"models/worms/explosion1.spr",
	"models/worms/explosion2.spr",
	"models/worms/explosion3.spr"
}
new g_iExpSprite[3]

new g_iMsgBarTime,g_iMsgDeath,g_iMsgScoreInfo
new const g_ChargeSound[] = "wormsmod/puissance1.wav"

// sounds before attacking, don't work yet
new const g_AttackSound[] = "wormsmod/player/ambiance/attack"
new const g_iAttackSoundNum = 13

new const g_DeadModel[] = "models/worms/dead.mdl"

// GRAB
#define GRAB_COST 1000
#define GRAB_COUNT 10

#define GRAB_SPEED 1000.0
#define GRAB_MOVESPEED 300.0
#define TASK_REMOVE 14000
#define TASK_CHECK 15000
new const g_GrabModel[3][] = {
	"models/worms/weapons/v_grappin.mdl",
	"models/worms/weapons/p_grappin.mdl",
	"models/worms/weapons/r_grappin.mdl"
}
new const g_GrabSound[2][] = {
	"wormsmod/weapons/xbow_fire1.wav",
	"wormsmod/weapons/xbow_hit2.wav"
}
new weapon_grab
new cvar_grab_radius

// BAZOOKA
#define BAZOOKA_COST 1000
#define BAZOOKA_COUNT 99

#define BAZOOKA_SPEED 1000.0
new const g_BazookaModel[3][] = {
	"models/worms/weapons/v_bazooka.mdl",
	"models/worms/weapons/p_bazooka.mdl",
	"models/worms/weapons/r_bazooka.mdl"
}
new const g_BazookaSound[2][] = {
	"wormsmod/weapons/bazooka1.wav",
	"wormsmod/weapons/bazooka2.wav"
}
//new const g_BazookaName[] = "bazooka"
new weapon_bazooka

// GRENADE
#define GRENADE_COST 1000
#define GRENADE_COUNT 99

#define GRENADE_SPEED 1000.0
new const g_GrenadeModel[3][] = {
	"models/worms/weapons/v_grenade.mdl",
	"models/worms/weapons/p_grenade.mdl",
	"models/worms/weapons/w_grenade.mdl"
}
new const g_GrenadeSound[2][] = {
	"weapons/grenade_hit1.wav",
	"weapons/grenade_hit2.wav"
}
new weapon_grenade
new g_iUserDelay[32] = {3,...}
#define MOUSE_DELAY 1.0
new bool:in_attack2[32]

// CLUSTER GRENADE
#define CLUSTER_COST 1000
#define CLUSTER_COUNT 5

#define CLUSTER_FRAGMENTS 5
#define CLUSTER -15
new const g_ClusterModel[3][] = {
	"models/worms/weapons/v_cluster.mdl",
	"models/worms/weapons/p_cluster.mdl",
	"models/worms/weapons/w_cluster.mdl"
}
new weapon_cluster

// MINE
#define MINE_COST 1000
#define MINE_COUNT 15

new const g_MineModel[4][] = {
	"models/worms/weapons/v_mine.mdl",
	"models/worms/weapons/p_mine.mdl",
	"models/worms/weapons/w_mine.mdl",
	"models/worms/weapons/w_mineT.mdl" // it didn't work without this
}
new const g_MineSound[] = "wormsmod/weapons/mine1.wav"
new const g_MineName[] = "worms_mine"
#define MAX_MINES 64
new g_iMineId[MAX_MINES]
new g_iMineNum
new cvar_mine_radius
new weapon_mine

// SHOTGUN
#define SHOTGUN_COST 1000
#define SHOTGUN_COUNT 5

new const g_ShotgunModel[3][] = {
	"models/worms/weapons/v_shotgun.mdl",
	"models/worms/weapons/p_shotgun.mdl",
	"models/worms/weapons/w_shotgun.mdl"
}
new const g_ShotgunSound[2][] = {
	"wormsmod/weapons/shotgun1.wav",
	"wormsmod/weapons/shotgun2.wav"
}
new shotgun_ammo[32] = {-1,...}
new weapon_shotgun

// MINIGUN
#define MINIGUN_COST 1000
#define MINIGUN_COUNT 5

#define MINIGUN_DELAY 0.1
new const g_MinigunModel[3][] = {
	"models/worms/weapons/v_minigun.mdl",
	"models/worms/weapons/p_minigun.mdl",
	"models/worms/weapons/w_shotgun.mdl"
}
new const g_MinigunSound[] = "wormsmod/weapons/minigun.wav"
//new shotgun_ammo[32] = {-1,...}
new cvar_minigun_ammo
new cvar_minigun_accuracy
new weapon_minigun

// SHEEP
#define SHEEP_COST 1000
#define SHEEP_COUNT 3

#define SHEEP_LIFE 15.0
#define TASK_SHEEP 24000
#define TASK_SHEEP2 25000
new const g_SheepModel[3][] = {
	"models/worms/weapons/v_sheep.mdl",
	"models/worms/weapons/p_sheep.mdl",
	"models/worms/weapons/w_sheep.mdl"
}
new const g_SheepRadioModel[2][] = {
	"models/worms/weapons/v_sheep_radio.mdl",
	"models/worms/weapons/p_sheep_radio.mdl"
}
new const g_SheepSound[] = "wormsmod/weapons/sheep1.wav"
new weapon_sheep
new sheepactive[32]

// BATTE
#define CLUB_COST 1000
#define CLUB_COUNT 7

new const g_ClubModel[2][] = {
	"models/worms/weapons/v_club.mdl",
	"models/worms/weapons/p_club.mdl"
}
new const g_ClubSound[4][] = {
	"wormsmod/weapons/club_music.wav",
	"wormsmod/weapons/club_player.wav",
	"wormsmod/weapons/club_air.wav",
	"wormsmod/weapons/club_world.wav"
}
new weapon_club
new cvar_club_power

// SUPER SHEEP
#define SUPERSHEEP_COST 1000
#define SUPERSHEEP_COUNT 5

#define SUPERSHEEP_LIFE 15.0
new const g_SuperSheepModel[3][] = {
	"models/worms/weapons/v_super_sheep.mdl",
	"models/worms/weapons/p_super_sheep.mdl",
	"models/worms/weapons/w_super_sheep.mdl"
}
new weapon_supersheep
new cvar_supersheep_speed

// AIR STRIKE
#define AIRSTRIKE_COST 1000
#define AIRSTRIKE_COUNT 5

#define AIRSTRIKE_TARGET -27
#define TASK_AIRTARGET 16000
new const g_AirStrikeModel[4][] = {
	"models/worms/weapons/v_air_strike.mdl",
	"models/worms/weapons/p_air_strike.mdl",
	"models/worms/weapons/r_air_strike.mdl",
	"models/worms/weapons/croix.spr"
}
new const g_AirStrikeSound[] = "wormsmod/weapons/air_strike1.wav"
new weapon_airstrike
new cvar_airstrike_count // number of rockets
new cvar_airstrike_radius 
new cvar_airstrike_degrees
new airstrike_sprite[32]




///////TEMP/////////////
public ResetCmd(id,level,cid)
{
	if(!cmd_access(id,level,cid,2))
	{
		return PLUGIN_HANDLED
	}
	new arg[15]
	read_argv(1,arg,14)
	
	new index = cmd_target(id, arg, 4);
	ResetFire(index)
	ResetModel(index)
	
	return PLUGIN_HANDLED
}










////////////////////////////
///// PLUGIN START /////////
////////////////////////////

public plugin_init() 
{
	register_plugin("Worms Weapons", VERSION, "Monyak")
	
	maxplayers = get_maxplayers()
	
	register_forward(FM_PlayerPreThink,"FM_PlayerPreThink_Hook")
	register_forward(FM_Touch, "FM_Touch_Hook")
	register_forward(FM_Think, "FM_Think_Hook")
	RegisterHam(Ham_Spawn,"player","Ham_Spawn_Hook",1)
	
	register_clcmd("reset","ResetCmd",ADMIN_KICK)
	
	
	g_iMsgBarTime = get_user_msgid("BarTime")
	g_iMsgDeath = get_user_msgid("DeathMsg")
	g_iMsgScoreInfo = get_user_msgid("ScoreInfo")
	
	register_event("HLTV", "EventNewround", "a", "1=0", "2=0")
	register_event("DeathMsg", "DeathMsg", "a", "2!0")
	
	
	cvar_firedamage = register_cvar("worms_fire_damage","5.0")
	// GRAB
	cvar_grab_radius = register_cvar("worms_grab_radius","1000.0")
	weapon_grab = worms_register_weapon("Grabbing Hook",WEAPON_MOVEMENT,GRAB_COUNT,GRAB_COST)
	// BAZOOKA
	weapon_bazooka = worms_register_weapon("Bazooka",WEAPON_ROCKET,BAZOOKA_COUNT,BAZOOKA_COST)
	cvars[weapon_bazooka] = register_cvar("worms_bazooka_damage","50.0")
	// GRENADE
	weapon_grenade = worms_register_weapon("Grenade",WEAPON_GRENADE,GRENADE_COUNT,GRENADE_COST)
	cvars[weapon_grenade] = register_cvar("worms_grenade_damage","50.0")
	// CLUSTER GRENADE
	weapon_cluster = worms_register_weapon("Frag Grenade",WEAPON_GRENADE,CLUSTER_COUNT,CLUSTER_COST)
	cvars[weapon_cluster] = register_cvar("worms_frag_damage","30.0")
	// MINE
	cvar_mine_radius = register_cvar("worms_mine_radius","50.0")
	weapon_mine = worms_register_weapon("Mine",WEAPON_EXPLOSIVE,MINE_COUNT,MINE_COST)
	cvars[weapon_mine] = register_cvar("worms_mine_damage","50.0")
	// SHOTGUN
	weapon_shotgun = worms_register_weapon("Shotgun",WEAPON_RIFLE,SHOTGUN_COUNT,SHOTGUN_COST)
	cvars[weapon_shotgun] = register_cvar("worms_shotgun_damage","30.0")
	// MINIGUN
	cvar_minigun_ammo = register_cvar("worms_minigun_ammo","30")
	cvar_minigun_accuracy = register_cvar("worms_minigun_accuracy","0.98")
	weapon_minigun = worms_register_weapon("Minigun",WEAPON_RIFLE,MINIGUN_COUNT,MINIGUN_COST)
	cvars[weapon_minigun] = register_cvar("worms_minigun_damage","4.0")
	// SHEEP
	weapon_sheep = worms_register_weapon("Sheep",WEAPON_ROCKET,SHEEP_COUNT,SHEEP_COST)
	cvars[weapon_sheep] = register_cvar("worms_sheep_damage","70.0")
	// CLUB
	weapon_club = worms_register_weapon("Baseball Bat",WEAPON_MELEE,CLUB_COUNT,CLUB_COST)
	cvars[weapon_club] = register_cvar("worms_club_damage","30.0")
	cvar_club_power = register_cvar("worms_club_power","600.0")
	// SUPER SHEEP
	weapon_supersheep = worms_register_weapon("Super Sheep",WEAPON_ROCKET,SUPERSHEEP_COUNT,SUPERSHEEP_COST)
	cvars[weapon_supersheep] = register_cvar("worms_supersheep_damage","60.0")
	cvar_supersheep_speed = register_cvar("worms_supersheep_speed","600.0")
	// AIR STRIKE
	weapon_airstrike = worms_register_weapon("Air Strike",WEAPON_AIRCRAFT,AIRSTRIKE_COUNT,AIRSTRIKE_COST)
	cvars[weapon_airstrike] = register_cvar("worms_airstrike_damage","30.0")
	cvar_airstrike_count = register_cvar("worms_airstrike_count","10")
	cvar_airstrike_radius = register_cvar("worms_airstrike_radius","100.0")
	cvar_airstrike_degrees = register_cvar("worms_airstrike_degrees","720.0")
	
	LoadMines()
}
public plugin_precache()
{
	new i
	
	for(i=0;i<3;i++)
	{
		precache_model(g_GrabModel[i])
		precache_model(g_BazookaModel[i])
		precache_model(g_GrenadeModel[i])
		precache_model(g_ClusterModel[i])
		precache_model(g_MineModel[i])
		precache_model(g_ShotgunModel[i])
		precache_model(g_MinigunModel[i])
		precache_model(g_SheepModel[i])
		precache_model(g_SuperSheepModel[i])
	}
	for(i=0;i<2;i++)
	{
		precache_model(g_ClubModel[i])
		precache_model(g_SheepRadioModel[i])
	}
	precache_model(g_MineModel[3])
	
	
	for(i=0;i<2;i++)
	{
		precache_sound(g_GrabSound[i])
		precache_sound(g_BazookaSound[i])
		precache_sound(g_GrenadeSound[i])
		precache_sound(g_ShotgunSound[i])
	}
	precache_sound(g_MineSound)
	precache_sound(g_MinigunSound)
	precache_sound(g_SheepSound)
	precache_sound(g_AirStrikeSound)
	for(i=0;i<4;i++)
	{	
		precache_sound(g_ClubSound[i])
		precache_model(g_AirStrikeModel[i])
	}
	
	precache_model(g_HandsModel)
	precache_sound(g_ChargeSound)
	precache_model(g_FragModel)
	precache_model(g_DeadModel)
	g_iFireIndex = precache_model(g_FireModel)
	g_iBeamIndex = precache_model("sprites/laserbeam.spr")
	for(i=0;i<3;i++)
	{
		g_iExpSprite[i] = precache_model(g_ExpSprite[i])
	}
	new temp[50]
	for(i=0;i<g_iAttackSoundNum;i++)
	{
		format(temp,49,"%s%s%d.wav",g_AttackSound,(i+1)<10?"0":"",i+1)
		precache_sound(temp)
	}
}



public worms_weapon_selected(id,weaponid)
{
	if(is_user_alive(id) && worms_get_allowfire(id) > 0)
	{
		ResetModel(id)
		if(weaponid == weapon_grab)
			GrabSelected(id)
		else if(weaponid == weapon_bazooka)
			BazookaSelected(id)
		else if(weaponid == weapon_grenade)
			GrenadeSelected(id)
		else if(weaponid == weapon_cluster)
			ClusterSelected(id)
		else if(weaponid == weapon_mine)
			MineSelected(id)
		else if(weaponid == weapon_shotgun)
			ShotgunSelected(id)
		else if(weaponid == weapon_minigun)
			MinigunSelected(id)
		else if(weaponid == weapon_sheep)
			SheepSelected(id)
		else if(weaponid == weapon_club)
			ClubSelected(id)
		else if(weaponid == weapon_supersheep)
			SuperSheepSelected(id)
		else if(weaponid == weapon_airstrike)
			AirStrikeSelected(id)
			
	}
}

public FM_PlayerPreThink_Hook(id)
{
	if(!is_user_alive(id))
		return FMRES_IGNORED
	new button = pev(id,pev_button)
	new Float: ftemp[3]
	if(worms_get_active_weapon(id) == -1)
	{
		/*if(button & IN_ATTACK && AllowFire(id))
		{
			WeaponAnim(id+TASK_ANIM,2)
			worms_set_allowfire(id, 0)
			set_task(50.0/24,"ResetAnim",id)
			set_task(50.0/24,"ResetFire",id+TASK_RESETFIRE)
		}*/
	}	
	else if(worms_get_active_weapon(id) == weapon_grab)
	{
		if(button & IN_ATTACK)
			if(worms_get_user_ammo(id,weapon_grab) && AllowFire(id))
				FireHook(id)
			else if(worms_get_allowfire(id) < 0)
			{
				new Float:origin[3]
				pev(id,pev_origin,ftemp)
				pev(-worms_get_allowfire(id),pev_origin,origin)
				for(new i=0;i<3;i++)
					origin[i] -= ftemp[i]
				vector_to_angle(origin,ftemp)
				ftemp[0] = -ftemp[0]
				pev(id,pev_velocity,origin)
				ChangeAnimation(id,4)
				num_to_vector(GRAB_MOVESPEED,ftemp,origin,false)
				set_pev(id,pev_velocity,origin)
			}
		if((button & IN_ATTACK2 || worms_is_user_locked(id)) && worms_get_allowfire(id) < 0)
			RemoveHook(-worms_get_allowfire(id)+TASK_REMOVE)
	}
	else if(worms_get_active_weapon(id) == weapon_bazooka
		|| hold_grenade(id))
	{
		if(button & IN_ATTACK && AllowFire(id) && worms_get_incharge(id) <= ZERO)
		{
			if(worms_get_active_weapon(id) == weapon_grenade)
				ChangeAnimation(id,3)
			worms_set_incharge(id,get_gametime())
			BarTime(id,CHARGE_DURATION)
		}
		if(worms_get_incharge(id) > ZERO)
		{
			new Float:diff = get_gametime()-worms_get_incharge(id)
			if(!(button & IN_ATTACK) || diff >= CHARGE_DURATION)
			{
				if(worms_get_active_weapon(id) == weapon_bazooka)
					LaunchRocket(id,diff/CHARGE_DURATION)
				else if(worms_get_active_weapon(id) == weapon_grenade)
					LaunchGrenade(id,diff/CHARGE_DURATION,0)
				else if(worms_get_active_weapon(id) == weapon_cluster)
					LaunchGrenade(id,diff/CHARGE_DURATION,1)
				BarTime(id)
				worms_lock_player(id,3.0)
				worms_set_incharge(id,0.0)
			}
		}
		if(button & IN_ATTACK2 && worms_get_incharge(id) <= ZERO
			&& hold_grenade(id) && !in_attack2[id])
		{
			WaitAttack2(id)
			ChangeAnimation(id,5)
			ChangeDelay(id)
		}
			
	}
	else if(worms_get_active_weapon(id) == weapon_mine)
	{
		if(button & IN_ATTACK2 && AllowFire(id))
		{
			worms_set_allowfire(id, 0)
			ResetFire(id,2.0)
			ChangeAnimation(id,3)
			set_task(2.0,"ResetAnim",id)
		}
		if(button & IN_ATTACK && AllowFire(id))
		{
			worms_set_allowfire(id, 0)
			if(task_exists(id+TASK_ANIM))
				remove_task(id+TASK_ANIM)
			ChangeAnimation(id,4)
			set_task(40.0/24,"DropMine",id)
			ResetFire(id,3.0)
			worms_lock_player(id,4.0)
		}
	}
	else if(worms_get_active_weapon(id) == weapon_shotgun)
	{
		if(button & IN_ATTACK && AllowFire(id))
		{
			worms_set_allowfire(id, 0)
			ChangeAnimation(id,1)
			PlaySound(id,g_ShotgunSound[1])
			if(--shotgun_ammo[id] <= 0)
			{
				worms_use_user_ammo(id,weapon_shotgun)
				shotgun_ammo[id] = 2
				set_task(25.0/50,"ResetModel",id)
				worms_lock_player(id,3.0)
			}
			ChangeAnimation(id,2,25.0/50)
			ResetFire(id,1.6)
			ShotgunFire(id,1)
		}
		if(button & IN_ATTACK2 && AllowFire(id))
			if(shotgun_ammo[id] == 2)
			{
				worms_set_allowfire(id, 0)
				ResetFire(id,1.6)
				ChangeAnimation(id,1)
				PlaySound(id,g_ShotgunSound[0])
				worms_use_user_ammo(id,weapon_shotgun)
				shotgun_ammo[id] = 2
				ChangeAnimation(id,2,25.0/50)
				set_task(1.6,"ResetModel",id)
				ShotgunFire(id,2)
				worms_lock_player(id,3.0)
			}
	}
	else if(worms_get_active_weapon(id) == weapon_minigun)
	{
		if(button & IN_ATTACK && AllowFire(id))
		{
			worms_set_allowfire(id, 0)
			worms_use_user_ammo(id,weapon_minigun)
			ChangeAnimation(id,1)
			new ammo = get_pcvar_num(cvar_minigun_ammo)
			set_task(MINIGUN_DELAY,"MinigunShoot",id,_,_,"a",ammo)
			ChangeAnimation(id,0,MINIGUN_DELAY*ammo)
			ResetFire(id,MINIGUN_DELAY*ammo+0.5)
			set_task(MINIGUN_DELAY*ammo+0.5,"ResetModel",id)
			worms_lock_player(id,MINIGUN_DELAY*ammo+3.5)
		}	
	}
	else if(worms_get_active_weapon(id) == weapon_sheep)
	{
		if(!sheepactive[id])
		{
			if(button & IN_ATTACK2 && AllowFire(id))
			{
				worms_set_allowfire(id, 0)
				ChangeAnimation(id,2)
				ResetFire(id,5.0/3)
				ChangeAnimation(id,0,5.0/3)
			}
			if(button & IN_ATTACK && AllowFire(id))
			{
				worms_set_allowfire(id, 0)
				ChangeAnimation(id,3)
				worms_use_user_ammo(id,weapon_sheep)
				set_task(1.0,"LaunchSheep",id)
				worms_lock_player(id,3.0)
			}
		}
		else
		{
			if(worms_get_allowfire(id) && (button & IN_ATTACK2 || button & IN_ATTACK))
			{
				SheepExplosion(sheepactive[id]+TASK_SHEEP2)
				worms_set_active_weapon(id,-1)
				remove_task(sheepactive[id]+TASK_SHEEP2)
			}
		}
	}
	else if(worms_get_active_weapon(id) == weapon_club)
	{
		if(button & IN_ATTACK && AllowFire(id))
		{
			worms_set_allowfire(id, 0)
			ClubFire(id)
			worms_lock_player(id,3.0)
		}
		if(button & IN_ATTACK2 && AllowFire(id))
		{
			worms_set_allowfire(id, 0)
			ChangeAnimation(id,1)
			ResetFire(id,1.9)
			ChangeAnimation(id,0,1.9)
		}
	}
	else if(worms_get_active_weapon(id) == weapon_supersheep)
	{
		if(!sheepactive[id])
		{
			if(button & IN_ATTACK && AllowFire(id))
			{
				worms_set_allowfire(id, 0)
				ChangeAnimation(id,2)
				worms_use_user_ammo(id,weapon_supersheep)
				set_task(1.0,"LaunchSuperSheep",id)
			}
		}
		else
		{
			new Float:angle[3],Float:velocity[3]
			pev(id,pev_v_angle,angle)
			if(pev_valid(sheepactive[id]))
			{
				num_to_vector(get_pcvar_float(cvar_supersheep_speed),
					angle,velocity,false)
				//angle[0] = -angle[0]
				set_pev(sheepactive[id],pev_velocity,velocity)
				set_pev(pev(sheepactive[id],pev_iuser3),pev_velocity,velocity)
				pev(sheepactive[id],pev_origin,velocity)
				set_pev(pev(sheepactive[id],pev_iuser3),pev_origin,velocity)
				set_pev(pev(sheepactive[id],pev_iuser3),pev_angles,angle)
				angle[0] = -angle[0]
				set_pev(sheepactive[id],pev_angles,angle)
				
				
			}
			else engfunc(EngFunc_SetView,id,id)
			if(button & IN_ATTACK2 || button & IN_ATTACK)
			{
				SheepExplosion(sheepactive[id]+TASK_SHEEP2)
				remove_task(sheepactive[id]+TASK_SHEEP2)
			}
		}
	}
	else if(worms_get_active_weapon(id) == weapon_airstrike)
	{
		CheckSprite(id)
		if(!airstrike_sprite[id])
		{
			if(button & IN_ATTACK && AllowFire(id))
			{
				worms_set_allowfire(id, 0)
				airstrike_sprite[id] = AirStrikeTarget(id)
				ChangeAnimation(id,3)
				ChangeAnimation(id,4,75.0/24)
				ResetFire(id,75.0/24)
			}
			if(button & IN_ATTACK2 && AllowFire(id))
			{
				worms_set_allowfire(id, 0)
				ChangeAnimation(id,2)
				ResetFire(id,15.0/8)
				ChangeAnimation(id,1,15.0/8)
			}	
		}
		else
		{
			if(button & IN_ATTACK && AllowFire(id))
			{
				worms_set_allowfire(id, 0)
				PlaySound(airstrike_sprite[id],g_AirStrikeSound)
				set_task(3.0,"AirStrikeFire",id)
				ChangeAnimation(id,5)
				ResetFire(id,1.0)
				set_task(1.0,"ResetModel",id)
				worms_lock_player(id,3.0)
				worms_use_user_ammo(id,weapon_airstrike)
			}
			if(button & IN_ATTACK2 && AllowFire(id))
			{
				AirStrikeSelected(id)
				if(pev_valid(airstrike_sprite[id]))
					fm_remove_entity(airstrike_sprite[id])
				airstrike_sprite[id] = 0
			}
		}
	}
	
	return FMRES_IGNORED
}
public FM_Touch_Hook(ent1,ent2)
{
	new ent,n
	ent = TouchCheck(n,ent1,ent2)
	if(!n)
		return FMRES_IGNORED
	if(pev_valid(ent))
	{
		new class = pev(ent,pev_weaponclass)
		if(class == WORMS_CRATE)
		{
			new Float:velocity[3]
			pev(ent,pev_velocity,velocity)
			velocity[2] /=3 
			set_pev(ent,pev_velocity,velocity)
		}
		else if(class == weapon_grab)
		{
			new id = pev(ent,pev_weaponowner)
			new Float:origin[3],Float:ftemp[3]
			pev(id,pev_origin,origin)
			pev(ent,pev_origin,ftemp)
			new Float: dist = get_distance_f(origin,ftemp)
			new Float: radius = get_pcvar_float(cvar_grab_radius)
			if(dist > radius || dist < 80.0)
			{
				RemoveHook(ent+TASK_REMOVE)
				return FMRES_IGNORED
			}
			remove_task(ent+TASK_REMOVE)
			worms_set_allowfire(id,-ent)
			worms_use_user_ammo(id,weapon_grab)
			set_pev(ent,pev_velocity,Float:{0.0,0.0,0.0})
			PlaySound(ent,g_GrabSound[1])
			set_task(1.0,"CheckHook",ent+TASK_CHECK,_,_,"b")
		}
		else if(class == weapon_bazooka || class == CLUSTER)
		{
			new id = pev(ent,pev_weaponowner)
			if((id == ent1 || id == ent2) && worms_get_weapon_ignore(id))
				return FMRES_IGNORED
			Explosion(ent)
			if(n == 2)
				Explosion(ent1)
		}
		else if(class == weapon_grenade || class == weapon_cluster)
		{
			new id = pev(ent,pev_weaponowner)
			if((id == ent1 || id == ent2) && worms_get_weapon_ignore(id)
				|| pev(ent,pev_iuser3) > 0)
				return FMRES_IGNORED
			PlaySound(ent,g_GrenadeSound[random(2)],0.3)
			new Float:velocity[3]
			pev(ent,pev_velocity,velocity)
			new Float:sum = 0.0
			for(new i=0;i<3;i++)
			{
				velocity[i] *= 3.0/4
				sum += floatabs(velocity[i])
			}
			if(sum < 32.0)
			{
				set_pev(ent,pev_iuser3,1)
				set_pev(ent,pev_velocity,Float:{0.0,0.0,0.0})
			}
			else set_pev(ent,pev_velocity,velocity)
		}
		else if(class == weapon_mine)
		{
			set_pev(ent,pev_movetype,MOVETYPE_NONE)
			set_pev(ent,pev_velocity,Float:{0.0,0.0,0.0})
			set_pev(ent,pev_angles,Float:{0.0,90.0,0.0})
			set_task(3.0,"MineActivate",ent)
			
		}
		else if(class == weapon_shotgun || class == weapon_minigun)
		{
			Explosion(ent)
		}
		else if(class == weapon_sheep)
		{
			new Float:velocity[3],Float:angle[3]
			pev(ent,pev_velocity,velocity)
			pev(ent,pev_angles,angle)
			num_to_vector(300.0,angle,velocity,false)
			velocity[2] = 0.0
			set_pev(ent,pev_velocity,velocity)	
		}
		else if(class == weapon_supersheep)
		{	
			new bool:flag = false
			if(pev_valid(ent2) && pev_valid(ent1))
			{
				flag = (pev(ent2,pev_weaponclass) != WORMS_CRATE)
				&& (pev(ent1,pev_weaponclass) != WORMS_CRATE)
				|| (pev(ent2,pev_iuser3) == 4 && pev(ent2,pev_weaponclass) == WORMS_CRATE)
				|| (pev(ent1,pev_iuser3) == 4 && pev(ent1,pev_weaponclass) == WORMS_CRATE)			
			}
			else if(ent1 == 0 || ent2 == 0)flag = true
			if(flag)
			{
				SheepExplosion(ent+TASK_SHEEP2)
				remove_task(ent+TASK_SHEEP2)
			}
		}
		else if(class == FIRE)
		{
			FireFrag(ent)
		}
		else if(class == weapon_airstrike)
		{
			Explosion(ent)
		}
			
	}
	return FMRES_IGNORED
}
public FM_Think_Hook(ent)
{
	if(!pev_valid(ent))
		return FMRES_IGNORED
	if(pev(ent,pev_worms) != WORMS_WEAPON)
		return FMRES_IGNORED
	new class = pev(ent,pev_weaponclass)	
	if(class == weapon_mine)
	{
		new player = 0
		new Float: radius = get_pcvar_float(cvar_mine_radius)
		new Float: origin[3]
		pev(ent,pev_origin,origin)
		new bool:activated = false
		while( (player = engfunc(EngFunc_FindEntityInSphere,player,origin,radius)) > 0)
		if(player>0 && player<=maxplayers)
			if(is_user_alive(player))
			{
				PlaySound(ent,g_MineSound,0.3)
				set_task(0.3,"MineSound",ent,_,0,"a",9)
				set_task(3.0,"Explosion",ent)
				activated = true
				if(!pev(ent,pev_weaponowner))
					set_pev(ent,pev_weaponowner,player)
				break;
			}
		if(!activated) set_pev(ent,pev_nextthink,get_gametime()+1.0)
		return FMRES_IGNORED
	}
	else if(class == weapon_sheep)
	{
		if(!task_exists(ent+TASK_SHEEP))
			set_task(random_float(0.5,3.0),"SheepJump",ent+TASK_SHEEP)
		set_pev(ent,pev_nextthink,get_gametime()+1.0)
		return FMRES_IGNORED
	}
	WindShift(ent)
	set_pev(ent,pev_nextthink,get_gametime()+0.1)
	return FMRES_IGNORED
}
public Ham_Spawn_Hook(id)
{
	if(!is_user_alive(id))
		return HAM_IGNORED
	fm_set_rendering(id)
	worms_set_active_weapon(id,-1)
	worms_set_weapon_ignore(id,false)
	shotgun_ammo[id] = -1
	ResetModel(id)
	if(worms_get_allowfire(id) < 0)
		RemoveHook(-worms_get_allowfire(id)+TASK_REMOVE)
	worms_set_allowfire(id, 1)
	return HAM_IGNORED
}

// GRAB
public GrabSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_grab)
	set_pev(id,pev_viewmodel2,g_GrabModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_GrabModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,0)
	ResetFire(id)
	
}
public FireHook(id)
{
	new ent = WeaponFire(id,worms_get_active_weapon(id),GRAB_SPEED,
		g_GrabModel[MODEL_BULLET],_,0.0,false)
	if(!pev_valid(ent))
		return
	beam(id,ent,_,0,0,5)
	new Float: radius = get_pcvar_float(cvar_grab_radius)
	set_task(radius/GRAB_SPEED,"RemoveHook",TASK_REMOVE+ent)
	PlaySound(id,g_GrabSound[0])
	ChangeAnimation(id,3)
}
public RemoveHook(ent)
{
	ent -= TASK_REMOVE
	if(pev_valid(ent))
	{
		new id = pev(ent,pev_weaponowner)
		worms_set_allowfire(id, 0)
		RemoveBeam(id)
		ResetGrabAnim(id)
		remove_task(ent+TASK_CHECK)
		fm_remove_entity(ent)
	}
}
public ResetGrabAnim(id)
{
	if(worms_get_user_ammo(id,weapon_grab) <= 0)
	{
		ResetModel(id)
		ResetFire(id)
		return
	}
	ChangeAnimation(id,5)
	ChangeAnimation(id,6,23.0/30)
	set_task(23.0/30+0.5,"ResetAnim",id)
	ResetFire(id,23.0/30+0.5)
}
public CheckHook(ent)
{
	ent -= TASK_CHECK
	if(!pev_valid(ent))
	{
		remove_task(ent+TASK_CHECK)
		return
	}
	new id = pev(ent,pev_weaponowner)
	new Float:origin[3],Float:ftemp[3]
	pev(id,pev_origin,origin)
	pev(ent,pev_origin,ftemp)
	new Float: dist = get_distance_f(origin,ftemp)
	new Float: radius = get_pcvar_float(cvar_grab_radius)
	if(dist > radius)
		RemoveHook(ent+TASK_REMOVE)
}
// BAZOOKA
public BazookaSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_bazooka)
	set_pev(id,pev_viewmodel2,g_BazookaModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_BazookaModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,2)
	ResetFire(id,11.0/25)
}
public LaunchRocket(id,Float:charge)
{
	new ent = WeaponFire(id,worms_get_active_weapon(id),BAZOOKA_SPEED*charge,
		g_BazookaModel[MODEL_BULLET],_,_)
	if(!pev_valid(ent))
		return
	set_pev(ent,pev_solid,SOLID_SLIDEBOX)
	new Float:mins[3],Float:maxs[3]
	pev(ent,pev_absmin,mins)
	pev(ent,pev_absmax,maxs)
	for(new i=0;i<3;i++)
	{
		mins[i] -= 2
		maxs[i] += 2
	}
	fm_entity_set_size(ent,mins,maxs)
	set_pev(ent,pev_classname,"Bazooka")
	PlaySound(id,g_BazookaSound[0])
	PlaySound(ent,g_BazookaSound[1], 0.7)
	BeamFollow(ent)
	ChangeAnimation(id,1)
	worms_use_user_ammo(id,worms_get_active_weapon(id))
	worms_set_active_weapon(id,-1)
	set_task(0.5,"ResetModel",id)
	ResetFire(id,0.5)
}
// GRENADE
public GrenadeSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_grenade)
	set_pev(id,pev_viewmodel2,g_GrenadeModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_GrenadeModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,0)
	ResetFire(id,0.5)
}
public LaunchGrenade(id,Float:charge,grentype)
{
	new ent = WeaponFire(id,worms_get_active_weapon(id),GRENADE_SPEED*charge,
		grentype?g_ClusterModel[MODEL_BULLET]:g_GrenadeModel[MODEL_BULLET],
		MOVETYPE_BOUNCEMISSILE,0.05,true)
	if(!pev_valid(ent))
		return
	set_pev(ent,pev_solid,SOLID_SLIDEBOX)
	set_task(float(g_iUserDelay[id]),"Explosion",ent)
	new Float:mins[3],Float:maxs[3]
	pev(ent,pev_absmin,mins)
	pev(ent,pev_absmax,maxs)
	for(new i=0;i<3;i++)
	{
		mins[i] -= 1
		maxs[i] += 1
	}
	fm_entity_set_size(ent,mins,maxs)
	set_pev(ent,pev_classname,"Grenade")
	ChangeAnimation(id,2)
	worms_use_user_ammo(id,worms_get_active_weapon(id))
	worms_set_active_weapon(id,-1)
	ResetModel(id)
	AttackSound(id)
	ResetFire(id,0.5)
}
// CLUSTER
public ClusterSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_cluster)
	set_pev(id,pev_viewmodel2,g_ClusterModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_ClusterModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,0)
	ResetFire(id,0.5)
}
// MINE
public LoadMines()
{
	new ent = 0
	static const targetname[] = "targetname"
	while((ent = engfunc(EngFunc_FindEntityByString,ent,targetname, g_MineName)) > 0)
	if(g_iMineNum < MAX_MINES)
		g_iMineId[g_iMineNum++] = ent
	else break
}
public CreateMines()
{
	new mine
	for(new i=0;i<g_iMineNum;i++)
		if(pev_valid(g_iMineId[i])) 
		{
			mine = pev(g_iMineId[i],pev_iuser4)
			if(pev_valid(mine))
				if(pev(mine,pev_weaponclass) == weapon_mine)
					continue
			mine = WeaponFire(g_iMineId[i],weapon_mine,0.0,g_MineModel[MODEL_BULLET],
				MOVETYPE_BOUNCE, 0.0, false)
			set_pev(mine,pev_classname,"Mine")			
			set_pev(g_iMineId[i],pev_iuser4,mine)
			
		}
}
public MineSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_mine)
	worms_set_allowfire(id, 0)
	set_pev(id,pev_viewmodel2,g_MineModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_MineModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,0)
	ResetFire(id,0.5)
	set_task(1.0,"ResetAnim",id)
}
public DropMine(id)
{
	new ent = WeaponFire(id,weapon_mine,0.0,g_MineModel[MODEL_BULLET],
		MOVETYPE_BOUNCE, 0.0, false)
	set_pev(ent,pev_classname,"Mine")
	worms_use_user_ammo(id,worms_get_active_weapon(id))
	worms_set_active_weapon(id,-1)
	ResetModel(id)
	
}
public MineActivate(ent)
{
	if(!pev_valid(ent))
		return
	set_pev(ent,pev_nextthink,get_gametime()+1.0)
	PlaySound(ent,g_MineSound,0.3)
}
public MineSound(ent)
{
	PlaySound(ent,g_MineSound,0.3)
}

// SHOTGUN
public ShotgunSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_shotgun)
	worms_set_allowfire(id, 0)
	set_pev(id,pev_viewmodel2,g_ShotgunModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_ShotgunModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,0)
	ResetFire(id,0.5)
	if(shotgun_ammo[id] == -1)
		shotgun_ammo[id] = 2
	//set_task(1.0,"ResetAnim",id)
}
public ShotgunFire(id,n)
{
	if(!is_user_alive(id))
		return
	new ent
	if(n == 2)
	{
		ent = Shoot(id, 5.0,weapon_shotgun)
		if(ent)set_pev(ent,pev_classname,"Shotgun")
		ent = Shoot(id, -5.0,weapon_shotgun)
		if(ent)set_pev(ent,pev_classname,"Shotgun")
		
	}
	else 
	{
		ent = Shoot(id,0.0,weapon_shotgun)
		if(ent)set_pev(ent,pev_classname,"Shotgun")
	}
}
public Shoot(id,Float:offset,weaponid)
{
	new ent = WeaponFire(id,weaponid,1000.0,
		g_ShotgunModel[MODEL_BULLET],
		MOVETYPE_FLY,0.0,false,offset)
	if(!pev_valid(ent))
		return 0
	set_pev(ent,pev_solid,SOLID_SLIDEBOX)
	new Float:mins[3],Float:maxs[3]
	pev(ent,pev_absmin,mins)
	pev(ent,pev_absmax,maxs)
	for(new i=0;i<3;i++)
	{
		mins[i] -= 0.5
		maxs[i] += 0.5
	}
	fm_entity_set_size(ent,mins,maxs)	
	BeamFollow(ent,2,1,_,_)
	return ent
	/*new Float:angle[3]
	pev(id,pev_v_angle,angle)
	angle[0] += random_float(0.0,1.0)
	angle[1] += random_float(-0.5,0.5)
	set_pev(id,pev_v_angle,angle)*/
}

// MINIGUN
public MinigunSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_minigun)
	worms_set_allowfire(id, 0)
	set_pev(id,pev_viewmodel2,g_MinigunModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_MinigunModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,2)
	ResetFire(id,20.0/13)
	ChangeAnimation(id,0,20.0/13)
}
public MinigunShoot(id)
{
	if(!is_user_alive(id))
		return
	PlaySound(id,g_MinigunSound)
	new ent = Shoot(id,0.0,weapon_minigun)
	if(ent)set_pev(ent,pev_classname,"Minigun")
	KnockBack(id,30.0)
}

// SHEEP
public SheepSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_sheep)
	worms_set_allowfire(id, 0)
	set_pev(id,pev_viewmodel2,g_SheepModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_SheepModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,4)
	ResetFire(id,1.0)
	ChangeAnimation(id,0,1.0)	
}
public LaunchSheep(id)
{
	new ent = WeaponFire(id,weapon_sheep,300.0,g_SheepModel[MODEL_BULLET],
		MOVETYPE_BOUNCE,0.0,true,_)
	if(!pev_valid(ent))
		return
	set_pev(ent,pev_solid,SOLID_SLIDEBOX)
	new Float:mins[3],Float:maxs[3],Float:angle[3]
	pev(ent,pev_angles,angle)
	angle[0] = 0.0
	set_pev(ent,pev_angles,angle)
	pev(ent,pev_absmin,mins)
	pev(ent,pev_absmax,maxs)
	for(new i=0;i<3;i++)
	{
		if(i!=2)mins[i] -= 12
		if(i!=2)maxs[i] += 12
		else maxs[i] += 24
	}
	fm_entity_set_size(ent,mins,maxs)
	set_pev(ent,pev_classname,"Sheep")
	PlaySound(ent,g_SheepSound)
	set_pev(ent,pev_framerate,1.0)
	set_pev(id,pev_weaponmodel2,g_SheepRadioModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,2)
	ChangeAnimation(id,0,1.0)
	worms_set_allowfire(id, 0)
	ResetFire(id,1.0)
	sheepactive[id] = ent
	if(task_exists(ent+TASK_SHEEP2))
		remove_task(ent+TASK_SHEEP2)
	set_task(SHEEP_LIFE,"SheepExplosion",ent+TASK_SHEEP2)
}
public SheepJump(ent)
{
	ent -= TASK_SHEEP
	if(!pev_valid(ent) || pev(ent,pev_flags) != FL_ONGROUND)
		return
	new Float:velocity[3],Float:angle[3]
	new Float:origin[3],Float:oldorigin[3]
	pev(ent,pev_origin,origin)
	pev(ent,pev_vuser1,oldorigin)
	new Float:distance = vector_distance(origin,oldorigin)
	pev(ent,pev_angles,angle)
	pev(ent,pev_origin,velocity)
	num_to_vector(-50.0,angle,velocity,true)
	set_pev(ent,pev_origin,velocity)
	if(distance < 64.0)
		angle[1] += 180
	num_to_vector(300.0,angle,velocity,false)
	velocity[2] = 500.0
	set_pev(ent,pev_velocity,velocity)
	set_pev(ent,pev_angles,angle)
	PlaySound(ent,g_SheepSound)
	set_pev(ent,pev_vuser1,origin)
}
public SheepExplosion(ent)
{
	ent -= TASK_SHEEP2
	if(!pev_valid(ent))
		return
	new id = pev(ent,pev_weaponowner)
	if(!is_user_connected(id))
		return
	new view = pev(ent,pev_iuser3)
	if(pev_valid(view))
		fm_remove_entity(view)
	if(worms_get_active_weapon(id) == weapon_sheep)
	{
		ChangeAnimation(id,1)
		ChangeAnimation(id,3,1.25)
		ResetFire(id,2.2)
		set_task(2.2,"ResetModel",id)
	}
	else
	{
		ResetModel(id)
		ResetFire(id,1.0)
		worms_lock_player(id,3.0)
		engfunc(EngFunc_SetView,id,id)
	}
	worms_set_allowfire(id, 0)
	sheepactive[id] = 0
	Explosion(ent)
}

// CLUB
public ClubSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_club)
	worms_set_allowfire(id, 0)
	set_pev(id,pev_viewmodel2,g_ClubModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_ClubModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,0)
	ResetFire(id,1.0)
}
public ClubFire(id)
{
	if(!is_user_alive(id))
		return
	worms_set_allowfire(id, 0)
	new Float: weapon[3],Float: origin[3]
	new Float: angle[3]
	pev(id,pev_v_angle,angle)
	pev(id,pev_origin,origin)
	pev(id,pev_origin,weapon)
	num_to_vector(120.0,angle,weapon)
	
	new trace,ent
	engfunc(EngFunc_TraceLine,origin,weapon,0,id,trace)
	ent = get_tr2(trace, TR_pHit)
	free_tr2(trace)
	
	if(is_user_alive(ent))
	{
		ChangeAnimation(id,3)
		ResetFire(id,18.0/25)
		ChangeAnimation(id,0,18.0/25)
		PlaySound(id,g_ClubSound[1])
		PlaySound(ent,g_ClubSound[0])
		
		new Float: speed = get_pcvar_float(cvar_club_power)
		new Float: velocity[3]
		pev(ent,pev_velocity,velocity)
		num_to_vector(speed,angle,velocity,false)
		set_pev(ent,pev_velocity,velocity)
		Damage(id,ent,get_pcvar_float(cvars[weapon_club]),"Club")
		
	}
	else if(ent >= 0)
	{
		ChangeAnimation(id,3)
		PlaySound(id,g_ClubSound[3])
	}
	else
	{
		ChangeAnimation(id,4)
		PlaySound(id,g_ClubSound[2])
	}
	worms_use_user_ammo(id,weapon_club)
	set_task(1.0,"ResetModel",id)
	ResetFire(id,1.0)
}

// SUPER SHEEP
public SuperSheepSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_supersheep)
	worms_set_allowfire(id, 0)
	set_pev(id,pev_viewmodel2,g_SuperSheepModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_SuperSheepModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,0)
	ChangeAnimation(id,1,1.0)
	ResetFire(id,1.0)	
}
public LaunchSuperSheep(id)
{
	new ent = WeaponFire(id,weapon_supersheep,get_pcvar_float(cvar_supersheep_speed),
	g_SuperSheepModel[MODEL_BULLET],MOVETYPE_FLY,0.0,false,_)
	if(!pev_valid(ent))
		return
	new Float:mins[3],Float:maxs[3]
	new view = fm_create_entity("info_target")
	set_pev(ent,pev_iuser3,view)
	set_pev(view,pev_movetype,MOVETYPE_FLY)
	engfunc(EngFunc_SetModel,view,g_SuperSheepModel[MODEL_BULLET])
	fm_set_rendering(view,_,_,_,_,kRenderTransAlpha,0)
	set_pev(view,pev_solid,SOLID_NOT)
	pev(ent,pev_origin,mins)
	set_pev(view,pev_origin,mins)
	
	pev(ent,pev_absmin,mins)
	pev(ent,pev_absmax,maxs)
	for(new i=0;i<3;i++)
	{
		if(i!=2)mins[i] -= 12
		if(i!=2)maxs[i] += 12
		else maxs[i] += 24
	}
	fm_entity_set_size(ent,mins,maxs)
	fm_entity_set_size(view,mins,maxs)
	set_pev(ent,pev_classname,"SuperSheep")
	PlaySound(ent,g_SheepSound)
	set_pev(ent,pev_framerate,1.0)
	
	set_pev(ent,pev_solid,SOLID_NOT)
	set_task(0.5,"ChangeSolid",ent)
	worms_set_allowfire(id, 0)
	sheepactive[id] = ent
	
	engfunc(EngFunc_SetView,id,view)
	if(task_exists(ent+TASK_SHEEP2))
		remove_task(ent+TASK_SHEEP2)
	set_task(SHEEP_LIFE,"SheepExplosion",ent+TASK_SHEEP2)
}
public ChangeSolid(ent)
{
	if(pev_valid(ent))
		set_pev(ent,pev_solid,SOLID_SLIDEBOX)
}

// AIR STRIKE
public AirStrikeSelected(id)
{
	if(!is_user_alive(id))
		return
	CheckSprite(id)
	worms_set_active_weapon(id,weapon_airstrike)
	worms_set_allowfire(id, 0)
	set_pev(id,pev_viewmodel2,g_AirStrikeModel[MODEL_FIRSTPERSON])
	set_pev(id,pev_weaponmodel2,g_AirStrikeModel[MODEL_THIRDPERSON])
	ChangeAnimation(id,0)
	ChangeAnimation(id,1,11.0/12)
	ResetFire(id,1.0)	
}
public CheckSprite(id)
{
	if(airstrike_sprite[id])
		if(pev_valid(airstrike_sprite[id]))
			{
				if(pev(airstrike_sprite[id],pev_worms) == AIRSTRIKE_TARGET)
					fm_remove_entity(airstrike_sprite[id])
			}
		else airstrike_sprite[id] = 0
}
public AirStrikeTarget(id)
{
	new origin[3],Float:forigin[3]
	get_user_origin(id,origin,3)
	for(new i=0;i<3;i++)
		forigin[i] = float(origin[i])
	//log_amx("target: %f %f %f",forigin[0],forigin[1],forigin[2])
	
	new ent = fm_create_entity("info_target")
	set_pev(ent,pev_origin,forigin)
	engfunc(EngFunc_SetModel,ent,g_AirStrikeModel[3])
	fm_set_rendering(ent,_,_,_,_,kRenderTransAdd,255)
	set_pev(ent,pev_weaponowner,id)
	set_task(1.0,"CheckTarget",ent+TASK_AIRTARGET,_,_,"b")
	return ent
}
public CheckTarget(ent)
{
	ent -= TASK_AIRTARGET
	if(pev_valid(ent))
		if(pev(ent,pev_worms) == AIRSTRIKE_TARGET)
		if(worms_get_active_weapon(pev(ent,pev_weaponowner)) == weapon_airstrike
			|| worms_get_active_weapon(pev(ent,pev_weaponowner)) == weapon_airstrike) //napalm
		{}
		else
		{
			airstrike_sprite[pev(ent,pev_weaponowner)] = 0
			fm_remove_entity(ent)			
		}
}
public AirStrikeFire(id)
{
	if(!is_user_connected(id))
		return
	new i,j
	new Float:origin[3]
	if(pev_valid(airstrike_sprite[id]))
	{
		pev(airstrike_sprite[id],pev_origin,origin)
		fm_remove_entity(airstrike_sprite[id])
		airstrike_sprite[id] = 0
	}
		
	new trace,Float:end[3]
	for(i=0;i<2;i++) 
		end[i] = origin[i]
	end[2] = origin[2] + 600
	engfunc(EngFunc_TraceLine,origin,end,IGNORE_MONSTERS|IGNORE_GLASS|IGNORE_MISSILE,id,trace)
	get_tr2(trace, TR_vecEndPos, origin)
	free_tr2(trace)
	
	new count = get_pcvar_num(cvar_airstrike_count)
	new Float:radius = get_pcvar_float(cvar_airstrike_radius)
	new Float:deg = get_pcvar_float(cvar_airstrike_degrees)
	for(i=0;i<count;i++)
	{
		for(j=0;j<3;j++)
			end[j] = origin[j]
		end[0] += (i*radius/count+random(8)) * floatcos(i*deg/count,degrees)
		end[1] += (i*radius/count+random(8)) * floatsin(i*deg/count,degrees)
		end[2] += -30+random(60)
		CreateBomb(id,end,0) // 0 = airstrike		
	}
}
public CreateBomb(id,Float:origin[3],type)
{
	new ent = fm_create_entity("info_target")
	if(!pev_valid(ent))
		return 0
	set_pev(ent,pev_worms,WORMS_WEAPON)
	set_pev(ent,pev_movetype,MOVETYPE_BOUNCE)
	engfunc(EngFunc_SetModel,ent,g_AirStrikeModel[MODEL_BULLET])
	set_pev(ent,pev_origin,origin)
	new Float:ftemp[3]
	ftemp[0] = -180.0
	ftemp[1] = 0.0
	ftemp[2] = 0.0
	set_pev(ent,pev_angles,ftemp)

	new Float:mins[3],Float:maxs[3]
	pev(ent,pev_absmin,mins)
	pev(ent,pev_absmax,maxs)
	for(new i=0;i<3;i++)
	{
		mins[i] -= 6
		maxs[i] += 6
	}
	fm_entity_set_size(ent,mins,maxs)
	set_pev(ent,pev_solid,SOLID_SLIDEBOX)
	new weaponid
	switch(type)
	{
		case 0: weaponid = weapon_airstrike
		default: weaponid = -1
	}
	set_pev(ent,pev_weaponclass,weaponid)
	set_pev(ent,pev_shift,0.1)
	set_pev(ent,pev_nextthink,get_gametime()+0.1)
	set_pev(ent,pev_weaponowner,id)
	set_pev(ent,pev_sequence,0)
	set_pev(ent,pev_framerate,1.0)
	set_pev(ent,pev_frame,1)
	
	new Float:damage = get_pcvar_float(cvars[weaponid])
	set_pev(ent,pev_damage,damage)
	set_pev(ent,pev_health,damage)
	
	return ent
}

















// STOCKS
stock WeaponFire(id,weaponid,Float:speed,const model[],	movetype = MOVETYPE_FLY,Float:shift = 1.0,bool:think = true,Float:offset=0.0)
{
	new ent = fm_create_entity("info_target")
	if(!pev_valid(ent))
		return 0
	set_pev(ent,pev_worms,WORMS_WEAPON)
	
	set_pev(ent,pev_movetype,movetype)
	engfunc(EngFunc_SetModel,ent,model)
	new Float:ftemp[3]
	GetWeaponOrigin(id,ftemp,offset)
	set_pev(ent,pev_origin,ftemp)
	pev(id,pev_v_angle,ftemp)
	ftemp[0] = -ftemp[0]
	if(weaponid == weapon_minigun)
	{
		new Float:accuracy = get_pcvar_float(cvar_minigun_accuracy)
		if(accuracy < 1.0)
		{
			ftemp[0] += (1 - random_float(accuracy,1.0))*90
			ftemp[1] += (1 - random_float(accuracy,1.0))*180
		}
	}
	set_pev(ent,pev_angles,ftemp)
	
	ftemp[0] = -ftemp[0]
	new Float:velocity[3]
	num_to_vector(speed,ftemp,velocity,false)
	set_pev(ent,pev_velocity,velocity)
	
	set_pev(ent,pev_weaponclass,weaponid)
	set_pev(ent,pev_shift,shift)
	if(worms_get_weapon_type(weaponid) != WEAPON_MOVEMENT)
	{
		new Float:damage = get_pcvar_float(cvars[weaponid])
		set_pev(ent,pev_damage,damage)
		set_pev(ent,pev_health,damage)
	}
	if(think)
		set_pev(ent,pev_nextthink,get_gametime()+0.1)
	if(is_user_connected(id))
	{
		set_pev(ent,pev_weaponowner,id)
		worms_set_allowfire(id, 0)
		worms_set_weapon_ignore(id,true)
		set_task(1.0,"ResetIgnore",id)
	}
	else set_pev(ent,pev_weaponowner,0)
	return ent
}
stock beam(const ent, const ent2,const Float: color[3]={255.0,255.0,255.0},noise=25,life=2,width=50,amt=200)
{
	new icolor[3]
	for(new i=0;i<3;i++)
		icolor[i] = floatround(color[i])
	message_begin(MSG_BROADCAST ,SVC_TEMPENTITY)
	write_byte(TE_BEAMENTS)	// beam effect between two ents
	write_short(ent)
	write_short(ent2)
	write_short(g_iBeamIndex)	// sprite index
	write_byte(0)	// starting frame
	write_byte(5)	// frame rate in 0.1's
	write_byte(life)	// life in 0.1's
	write_byte(width)	// line width in 0.1's
	write_byte(noise)// noise amplitude in 0.01's
	write_byte(icolor[0])	// Red
	write_byte(icolor[1])	// Green
	write_byte(icolor[2])	// Blue
	write_byte(amt)	// brightness
	write_byte(35)	// scroll speed in 0.1's
	message_end()
}
public RemoveBeam(id) 
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_KILLBEAM)
	write_short(id)	//entity
	message_end()
}
stock num_to_vector(const Float: value, const Float:angle[3],Float: origin[3], bool: addit = true)
{ 
	if(addit)
	{
		origin[0] += value*floatcos(angle[1],degrees)*floatcos(-angle[0],degrees)
		origin[1] += value*floatsin(angle[1],degrees)*floatcos(-angle[0],degrees)
		origin[2] += value*floatsin(-angle[0],degrees)
	}
	else 
	{
		origin[0] = value*floatcos(angle[1],degrees)*floatcos(-angle[0],degrees)
		origin[1] = value*floatsin(angle[1],degrees)*floatcos(-angle[0],degrees)
		origin[2] = value*floatsin(-angle[0],degrees)
	}
}
public GetWeaponOrigin(id, Float: origin[3],Float:offset)
{
	new Float:angle[3],Float:ftemp[3]
	new Float:radius1,Float:radius2,Float:radius
	pev(id,pev_origin,origin)
	for(new i=0;i<3;i++)
		ftemp[i] = origin[i]
	pev(id,pev_v_angle,angle)

	if(floatabs(angle[0]) <= 66.0)
		radius1 = 22.0 / floatcos(angle[0],degrees)
	else radius1 = 44.0 / floatsin(angle[0],degrees)
	new Float:a = floatabs(angle[1])
	if(45<a<135)
		radius2 = 22.0 / floatsin(angle[1],degrees)
	else radius2 = 22.0 / floatcos(angle[1],degrees)

	radius = floatsqroot(radius1*radius1+radius2*radius2)

	num_to_vector(radius,angle,origin)
	if(offset > ZERO)
	{
		angle[1] += 90
		angle[0] = 0.0
		num_to_vector(offset,angle,origin)
	}
	origin[2] += 8.0 //angle[0] < ZERO? 8.0: 8.0
	new trace
	engfunc(EngFunc_TraceLine,ftemp,origin,IGNORE_MONSTERS|IGNORE_GLASS|IGNORE_MISSILE,id,trace)
	get_tr2(trace, TR_vecEndPos, origin)
	free_tr2(trace)
}
public AttackSound(id)
{
	if(!is_user_alive(id))
		return
	new sound[50]
	new rand = random(g_iAttackSoundNum)
	format(sound,49,"%s%s%d.wav",g_AttackSound,(rand+1)<10?"0":"",rand+1)
	PlaySound(id,sound)
}
stock PlaySound(ent,const sample[],Float:volume = 1.0,flags = 0)
{
	EF_EmitAmbientSound(ent,Float:{0.0,0.0,0.0},sample,volume, ATTN_NORM, flags, PITCH_NORM)
}
stock EF_EmitAmbientSound(const ENTITY, Float:pos[3], const SAMPLE[], Float:volume, Float:attenuation, fFlags, pitch)
{
	return engfunc(EngFunc_EmitAmbientSound, ENTITY, pos, SAMPLE, volume, attenuation, fFlags, pitch)
}
public ResetModel(id)
{
	worms_set_active_weapon(id,-1)
	set_pev(id,pev_viewmodel2,g_HandsModel)
	set_pev(id,pev_weaponmodel2,"")
}
stock ResetFire(id,Float:delay = 0.0)
{
	if(delay < ZERO)
		ResetFire2(id+TASK_RESETFIRE)
	else set_task(delay,"ResetFire2",id+TASK_RESETFIRE)
}
public ResetFire2(id)
{
	id-= TASK_RESETFIRE
	remove_task(id+TASK_RESETFIRE)
	if(worms_get_allowfire(id) == 0) worms_set_allowfire(id, 1)
}
public  ResetAnim(id)
{
	WeaponAnim(id+TASK_ANIM)
}
public ResetIgnore(id)
{
	worms_set_weapon_ignore(id,false)
}
stock ChangeAnimation(id,seq,Float:delay = 0.0)
{
	if(delay < ZERO)
		WeaponAnim(id+TASK_ANIM,seq)
	else
	{
		new value[2]
		value[0] = id
		value[1] = seq
		set_task(delay,"ChangeAnimTask",0, value, 2)
	}
}
public ChangeAnimTask(value[])
{
	WeaponAnim(value[0]+TASK_ANIM,value[1])
}
stock WeaponAnim(player,anim = 1) 
{ 
	player -= TASK_ANIM
	if(!is_user_alive(player))
		return
	set_pev(player, pev_weaponanim, anim) 
	message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, _, player) 
	write_byte(anim) 
	write_byte(pev(player, pev_body)) 
	message_end() 
}
public AllowFire(id)
{
	if(worms_allow_fire(id) && worms_get_allowfire(id) == 1)
		return true
	return false
}
stock in_move(id)
{
	new moves = IN_FORWARD | IN_BACK | IN_MOVELEFT | IN_MOVERIGHT
	if(pev(id,pev_button) & moves)
		return 1
	return 0
}
stock ExplosionSprite(ent,sprite, scale = 10, framerate = 10)
{
	if(!pev_valid(ent))
		return
	new Float: origin[3]
	pev(ent,pev_origin,origin)
	message_begin(MSG_BROADCAST ,SVC_TEMPENTITY)
	write_byte(TE_EXPLOSION)
	write_coord(floatround(origin[0]))	// start position
	write_coord(floatround(origin[1]))
	write_coord(floatround(origin[2]))
	write_short(sprite)	// sprite index
	write_byte(scale)	// scale in 0.1's
	write_byte(framerate)	// framerate
	write_byte(2)	// flags
	message_end()
}
stock BarTime(id,duration = 0)
{
	if(!is_user_connected(id))
		return
	message_begin(MSG_ONE_UNRELIABLE,g_iMsgBarTime,_,id)
	write_short(duration)
	message_end()
	if(duration) 
		PlaySound(id,g_ChargeSound)
	else 
		PlaySound(id,g_ChargeSound,_,SND_STOP)
}
stock BeamFollow(ent,life = 10,width = 10,const color[3] = {255,255,255},brightness = 200)
{
	if(!pev_valid(ent))
		return
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_BEAMFOLLOW)
	write_short(ent)
	write_short(g_iBeamIndex)
	write_byte(life) 
	write_byte(width) 
	write_byte(color[0])
	write_byte(color[1])
	write_byte(color[2])
	write_byte(brightness)
	message_end()
}
stock WindShift(ent)
{
	if(!pev_valid(ent))
		return
	new Float: shift
	pev(ent,pev_shift,shift)
	if(shift < ZERO || pev(ent,pev_flags) & FL_ONGROUND)
		return
	new windAngle = worms_get_wind_direction()
	new windPower = worms_get_wind_power()
	//new gravity = pev(ent,pev_movetype) == MOVETYPE_FLY? 1:0
	new Float:angle[3]
	new Float:velocity[3]
	pev(ent,pev_velocity,velocity)
	angle[0] = 0.0
	angle[1] = float(windAngle)
	num_to_vector(windPower*shift,angle,velocity)
	angle[1] = 0.0
	angle[0] = 90.0
	num_to_vector(0.3*GRAVITY,angle,velocity)
	
	if(pev(ent,pev_movetype) == MOVETYPE_BOUNCE) velocity[2] -= velocity[2]/4
	set_pev(ent,pev_velocity,velocity)
	if(pev(ent,pev_weaponclass) != WORMS_CRATE)
	{
		vector_to_angle(velocity,angle)
		angle[0] = angle[0] -270
		set_pev(ent,pev_angles,angle)
		
	}
}
public Explosion(ent)
{
	if(!pev_valid(ent) || is_user_alive(ent))
		return
	new id = pev(ent,pev_weaponowner)
	if(!is_user_connected(id) && id)
	{
		fm_remove_entity(ent)
		return
	}
	if(pev(ent,pev_weaponclass) == weapon_sheep)
	{
		worms_set_allowfire(id, 1)
		sheepactive[id] = 0
	}
	new type = pev(ent,pev_weaponclass)
	DamageExplosion(ent)
	if(ent > maxplayers && pev_valid(ent))
		fm_remove_entity(ent)
	else CreateRip(ent)
			
	if(worms_get_user_ammo(id,type) <= 0)
	{
		ResetModel(id)
		ResetFire(id)
		return
	}
}
public DamageExplosion(ent)
{
	new class = pev(ent,pev_weaponclass)
	new id = pev(ent,pev_weaponowner)
	if(pev(ent,pev_worms) == WORMS_WEAPON || pev(ent,pev_weaponclass) == WORMS_CRATE)
	if(class == weapon_bazooka)
	{
		ExplosionSprite(ent,g_iExpSprite[0],40,24)
		ExplosionSprite(ent,g_iExpSprite[1],20,24)
		PlaySound(ent,g_BazookaSound[1], _,SND_STOP)
	}
	else if(class == weapon_grenade || class == weapon_mine
		|| class == weapon_sheep || class == weapon_supersheep
		|| class == WORMS_CRATE)
	{
		ExplosionSprite(ent,g_iExpSprite[0],40,24)
		ExplosionSprite(ent,g_iExpSprite[1],20,24)
	}
	else if(class == weapon_cluster)
	{
		ExplosionSprite(ent,g_iExpSprite[0],40,24)
		ExplosionSprite(ent,g_iExpSprite[1],20,24)
		FragExplode(ent)
	}
	else if(class == CLUSTER)
	{
		ExplosionSprite(ent,g_iExpSprite[1],10,24)
	}
	else if(class == weapon_shotgun)
	{
		ExplosionSprite(ent,g_iExpSprite[1],5,24)
	}
	else if(class == weapon_minigun)
	{
		ExplosionSprite(ent,g_iExpSprite[1],2,48)
	}
	else if(class == weapon_airstrike)
	{
		ExplosionSprite(ent,g_iExpSprite[1],10,24)
	}
	if(is_user_connected(ent))
	{
		ExplosionSprite(ent,g_iExpSprite[0],40,24)
		ExplosionSprite(ent,g_iExpSprite[1],20,24)
	}
	new Float:origin[3]
	new Float:ftemp[3]
	pev(ent,pev_origin,origin)
	new player = 0
	new Float:damage
	if(is_user_connected(ent)) damage = 25.0
	else pev(ent,pev_damage,damage)
	new Float:radius = damage > 0?damage*4.0 : 1.0
	if(class == weapon_minigun) radius *= 3
	new Float:temp
	new weapon[32]
	pev(ent,pev_classname,weapon,31)
	
	while( 0 < (player = engfunc(EngFunc_FindEntityInSphere,player,origin,radius)) > 0)
	if(player>0 && player<=maxplayers)
	{
		if(is_user_alive(player))
		{
			pev(player,pev_origin,ftemp)
			temp = get_distance_f(ftemp,origin)
			new Float:realdamage = 1.0-temp*temp/radius/radius
			realdamage = realdamage < ZERO? 0.1:realdamage
			realdamage *= damage
			Damage(id,player,realdamage,weapon)
			PushEntity(player,ftemp,origin,realdamage)
				
			
		}
	}
	else if(pev_valid(player) && player != ent) // player = ent
	{
		pev(player,pev_origin,ftemp)
		temp = get_distance_f(ftemp,origin)
		new Float:realdamage = 1.0-temp*temp/radius/radius
		realdamage = realdamage < ZERO? 0.1:realdamage
		realdamage = damage*((temp < 32.0)?1.0:realdamage)
		if(pev(player,pev_weaponclass) == WORMS_CRATE)
		{
			new Float:hp
			pev(player,pev_health,hp)
			//log_amx("hp = %d %f",hp,hp)
			if(hp - realdamage < 1)
				FireExplosion(player)
			else set_pev(player,pev_health,hp-realdamage)
		}
		else if(pev(player,pev_takedamage) == DAMAGE_YES)
			fm_fakedamage(player,"worldspawn", realdamage, DMG_GENERIC)
	}
}
public FragExplode(ent)
{
	new Float:speed
	pev(ent,pev_damage,speed)
	new Float:angle[3]
	new Float:velocity[3]
	new frag
	for(new i=0;i<CLUSTER_FRAGMENTS;i++)
	{
		frag = CreateFrag(ent)
		if(!pev_valid(frag))
			return
		angle[0] = -float(random(90))
		angle[1] = float(random(360))
		angle[2] = 0.0
		num_to_vector(speed*3,angle,velocity,false)
		set_pev(frag,pev_velocity,velocity)
		set_pev(frag,pev_classname,"Cluster")	
	}
	
}
public CreateFrag(ent)
{
	new frag = fm_create_entity("info_target")
	if(!pev_valid(frag))
		return 0
	new Float:origin[3]
	pev(ent,pev_origin,origin)
	set_pev(frag,pev_origin,origin)
	engfunc(EngFunc_SetModel,frag,g_FragModel)
	set_pev(frag,pev_damage,get_pcvar_float(cvars[weapon_cluster]))
	set_pev(frag,pev_weaponowner,pev(ent,pev_weaponowner))
	set_pev(frag,pev_worms,WORMS_WEAPON)
	set_pev(frag,pev_weaponclass,CLUSTER)
	set_pev(frag,pev_movetype,MOVETYPE_FLY)
	set_pev(frag,pev_nextthink,get_gametime()+0.1)
	set_pev(frag,pev_shift,0.05)
	return frag
}
public FireExplosion(ent)
{
	new Float:speed
	pev(ent,pev_damage,speed)
	new Float:angle[3]
	new Float:velocity[3]
	new frag
	for(new i=0;i<FIRE_FRAGMENTS;i++)
	{
		frag = CreateFrag(ent)
		pev(frag,pev_origin,velocity)
		velocity[2] += 8
		set_pev(frag,pev_origin,velocity)
		if(!pev_valid(frag))
			return
		set_pev(frag,pev_weaponclass,FIRE)
		angle[0] = -float(random(90))
		angle[1] = float(random(360))
		angle[2] = 0.0
		num_to_vector(speed*3,angle,velocity,false)
		set_pev(frag,pev_velocity,velocity)
		set_pev(frag,pev_classname,"Fire")	
	}
	fm_remove_entity(ent)
}
public FireFrag(ent)
{
	if(!pev_valid(ent))
		return
	//new Float:o[3]
	//pev(ent,pev_origin,o)
	//log_amx("Fire at %f %f %f",o[0],o[1],o[2])
	new Float:origin[3]
	pev(ent,pev_origin,origin)
	fm_remove_entity(ent)
	CreateSprite(origin,g_iFireIndex)
	new Float:mins[3],Float:maxs[3]
	for(new i=0;i<3;i++)
	{
		mins[i] = origin[i] - 8
		maxs[i] = origin[i] + 8
	}
	new hurt = CreateHurt(mins,maxs,get_pcvar_float(cvar_firedamage))
	set_task(4.0,"RemoveEntity",hurt)
}
public RemoveEntity(ent)
{
	if(pev_valid(ent))
		fm_remove_entity(ent)
}
public CreateRip(id)
{
	if(is_user_alive(id) || !pev_valid(id))
		return 0
	
	new Float:origin[3]
	pev(id,pev_origin,origin)
	new Float:angle[3]
	pev(id,pev_v_angle,angle)
	angle[0] = 0.0
	fm_set_rendering(id,_,_,_,_,kRenderTransAlpha,0)
	
	new ent = CreateModel(origin,g_DeadModel)
	set_pev(ent,pev_classname,"Rip")
	set_pev(ent,pev_angles,angle)
	return ent
}
public CreateModel(Float:origin[3],const model[])
{
	new ent = fm_create_entity("info_target")
	if(!pev_valid(ent)) return 0
	engfunc(EngFunc_SetModel,ent,model)
	set_pev(ent,pev_origin,origin)
	set_pev(ent,pev_movetype,MOVETYPE_FLY)
	set_pev(ent,pev_sequence,0)
	set_pev(ent,pev_framerate,1.0)
	origin[0] = 0.0
	origin[1] = 0.0
	origin[2] = -150.0
	set_pev(ent,pev_velocity,origin)
	return ent
}
stock CreateSprite(Float:origin[3],sprite)
{
	new o[3]
	new temp[4]
	for(new i=0;i<3;i++)
	{
		o[i] = floatround(origin[i])
		temp[i] = o[i]
	}
	Sprite(o,sprite)
	temp[3] = sprite
	set_task(2.0,"RepeatSprite",0,temp,4)	
}
public RepeatSprite(parm[])
{
	new origin[3]
	for(new i=0;i<3;i++)
		origin[i] = parm[i]
	new sprite = parm[3]
	Sprite(origin,sprite)
}
stock Sprite(origin[3],sprite,scale = 10,brightness = 255)
{
	message_begin(MSG_BROADCAST ,SVC_TEMPENTITY)
	write_byte(TE_SPRITE)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2])
	write_short(sprite) 
	write_byte(scale) 
	write_byte(brightness)
	message_end()
}
public KnockBack(id,Float:value)
{
	new Float: angle[3],Float: velocity[3]
	if(!is_user_connected(id))
		return
	pev(id,pev_v_angle,angle)
	pev(id,pev_velocity,velocity)
	num_to_vector(-value,angle,velocity,true)
	set_pev(id,pev_velocity,velocity)
}
stock Damage(attacker,victim,Float:damage,const weapon[] = "")
{
	if(pev(victim,pev_health) - damage < 1)
		KillMsg(attacker,victim,weapon,0)
	else fm_fakedamage(victim,"worldspawn", damage, DMG_GENERIC)
}
public PushEntity(ent,const Float:ent_origin[3],const Float:origin[3],Float:damage)
{
	new Float:vector[3],Float:angle[3]
	for(new i=0;i<3;i++)
		vector[i] = ent_origin[i] - origin[i]
	vector_to_angle(vector,angle)
	angle[0] = -angle[0]
	pev(ent,pev_velocity,vector)
	num_to_vector(damage*10,angle,vector)
	set_pev(ent,pev_velocity,vector)
	
}
stock KillMsg(killer,victim,const weapon[],gibs=1)
{
	new team2 = get_user_team(victim)
	new team1
	if(killer) team1 = get_user_team(killer)
	else team1 = team2
	new Float:frags = (team1 == team2)?-1.0:1.0
	if(is_user_connected(killer))set_pev(killer,pev_frags,pev(killer,pev_frags)+frags)
	fm_set_user_deaths(victim,get_user_deaths(victim)+1)
	new Float:hp = pev(victim,pev_health) + 2.0
	TakeDamage(victim,killer,hp,gibs)
	CreateDeathmsg(victim,killer,weapon)
	RemoveBody(victim)
	set_task(0.2,"update_score",killer)
	set_task(0.2,"update_score",victim)
}
stock fm_set_user_deaths(id, value)
{
	if(pev_valid(id) == 2)
		set_pdata_int(id, OFFSET_CSDEATHS, value, OFFSET_LINUX)
}
public update_score(id)
{
	if(!is_user_connected(id))
		return
		
	new frags, deaths, team
	frags  = get_user_frags(id)
	deaths = get_user_deaths(id)
	team   = get_user_team(id)
	
	message_begin(MSG_BROADCAST, g_iMsgScoreInfo)
	write_byte(id)
	write_short(frags)
	write_short(deaths)
	write_short(0)
	write_short(team)
	message_end()
}
public CreateDeathmsg(victim,attacker,const weapon[])
{	
	message_begin(MSG_BROADCAST,g_iMsgDeath)
	write_byte(attacker)
	write_byte(victim)
	write_byte(0)
	write_string(weapon)
	message_end()
}
stock TakeDamage(victim,attacker,Float:damage,gibs=1)
{
	if(is_user_alive(victim))
		ExecuteHam(Ham_TakeDamage,victim,attacker,attacker,damage,(1<<6)+(gibs<<13))
}
public WaitAttack2(id)
{
	in_attack2[id] = true
	set_task(MOUSE_DELAY,"ResetAttack2",id)
}
public ResetAttack2(id)
{
	in_attack2[id] = false
}
public ChangeDelay(id)
{
	if(g_iUserDelay[id]++ >= 5)
		g_iUserDelay[id] = 1
	client_print(id,print_center,"%d seconds",g_iUserDelay[id])
}
public hold_grenade(id)
{
	if(worms_get_active_weapon(id) == weapon_grenade || worms_get_active_weapon(id) == weapon_cluster)
		return true
	return false
}
public TouchCheck(&n,ent1,ent2)
{
	n = 0
	new ent = 0
	if(pev_valid(ent1))
		if(pev(ent1,pev_worms) == WORMS_WEAPON)
			if(pev_valid(ent2))
			{
				if(pev(ent2,pev_solid) != SOLID_TRIGGER)
				{
					ent = ent1
					n++
				}
			}
			else
			{
				ent = ent1
				n++
			}
	if(pev_valid(ent2))
		if(pev(ent2,pev_worms) == WORMS_WEAPON)
			if(pev_valid(ent1))
			{
				if(pev(ent1,pev_solid) != SOLID_TRIGGER)
				{
					ent = ent2
					n++
				}
			}
			else
			{
				ent = ent2
				n++
			}
	return ent
}
public OwnerTouch(ent1,ent2)
{
	if(!ent1 || !ent2)
		return false
	if(pev_valid(ent1))
		if(pev(ent1,pev_weaponowner) == ent2)
			return true
	if(pev_valid(ent2))
		if(pev(ent2,pev_weaponowner) == ent1)
			return true
	return false
	
}
public EventNewround()
{
	
	CreateMines()
}
public DeathMsg()
{
	new victim = read_data(2)
	if(is_user_connected(victim))
		RemoveBody(victim)
}
public RemoveBody(id)
{
	set_task(3.0,"Explosion",id)
	set_pev(id,pev_viewmodel2,"")
}
public client_putinserver(id)
{
	worms_set_allowfire(id, 1)
	worms_set_active_weapon(id,-1)
}
stock CreateHurt(Float: mins[3],Float:maxs[3],Float:dmg)
{
	new ent = fm_create_entity("trigger_hurt")
	fm_DispatchSpawn(ent)
	set_pev(ent,pev_absmax,maxs)
	set_pev(ent,pev_absmin,mins)
	set_pev(ent,pev_dmg,dmg)
	fm_set_kvd(ent,"damagetype", "8" )
	set_pev(ent,pev_solid,SOLID_TRIGGER)
	return ent
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/
